/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalAnswers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.util.AttributeEvaluator;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.util.Car;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DWAttributeEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final String HOST_PORT_JSON = "{\"host\":\"0.0.0.0\", \"port\" : 8081}";
    private static final String JSON_CAR = "{\n  \"color\": \"RED\",\n  \"price\": 1000\n}";
    private static final String DW_CAR = "#[{color : 'RED', price: 1000}]";
    private static final String DW_CAR_LIST = "#[[{color : 'RED', price: 1000}]]";
    private static final DataType CAR_DATA_TYPE = DataType.fromType(Car.class);
    private static final DataType CAR_LIST_DATA_TYPE = DataType.builder().collectionType(List.class).itemType(Car.class).build();
    private Event mockMuleEvent = (Event)Mockito.mock(Event.class);
    private DefaultExpressionManager expressionManager;
    @Mock
    private StreamingManager streamingManager;

    @Before
    public void setUp() throws RegistrationException {
        Mockito.when((Object)this.streamingManager.manage((CursorProvider)org.mockito.Matchers.any(CursorProvider.class), (Event)org.mockito.Matchers.any(Event.class))).then(AdditionalAnswers.returnsFirstArg());
        this.expressionManager = new DefaultExpressionManager(muleContext, this.streamingManager);
    }

    @Test
    public void plainTextValue() {
        String staticValue = "attributeEvaluator";
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator(staticValue);
        MatcherAssert.assertThat((Object)attributeEvaluator.resolveValue(this.mockMuleEvent), (Matcher)CoreMatchers.is((Object)staticValue));
    }

    @Test
    public void getJavaStringFromIntJsonProperty() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.port]", DataType.STRING);
        Event event = this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON);
        Object port = attributeEvaluator.resolveValue(event);
        MatcherAssert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)"8081"));
    }

    @Test
    public void getJavaIntFromIntJsonProperty() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.port]", DataType.NUMBER);
        Event event = this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON);
        Object port = attributeEvaluator.resolveValue(event);
        MatcherAssert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)8081));
    }

    @Test
    public void getJavaStringFromStringJsonProperty() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.host]", DataType.STRING);
        Event event = this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON);
        Object host = attributeEvaluator.resolveValue(event);
        MatcherAssert.assertThat((Object)host, (Matcher)CoreMatchers.is((Object)"0.0.0.0"));
    }

    @Test
    public void getJavaObjectFromStringJsonProperty() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.host]", DataType.OBJECT);
        Event event = this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON);
        Object resolveValue = attributeEvaluator.resolveValue(event);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)((CursorProvider)resolveValue).openCursor())), (Matcher)CoreMatchers.is((Object)"\"0.0.0.0\""));
    }

    @Test
    public void getJavaInputStreamFromStringJsonProperty() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.host]", DataType.INPUT_STREAM);
        Event event = this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON);
        Object resolveValue = attributeEvaluator.resolveValue(event);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)((CursorProvider)resolveValue).openCursor())), (Matcher)CoreMatchers.is((Object)"\"0.0.0.0\""));
    }

    @Test
    public void getJavaPojo() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator(DW_CAR, DataType.fromType(Car.class));
        Object car = attributeEvaluator.resolveValue(this.newEvent());
        MatcherAssert.assertThat((Object)car, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasProperty((String)"color", (Matcher)CoreMatchers.is((Object)"RED")), (Matcher)Matchers.hasProperty((String)"price", (Matcher)CoreMatchers.is((Object)1000)))));
    }

    @Test
    public void getJavaCarFromJsonCar() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload]", CAR_DATA_TYPE);
        Object car = attributeEvaluator.resolveValue(this.newEvent(JSON_CAR, MediaType.APPLICATION_JSON));
        MatcherAssert.assertThat((Object)car, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasProperty((String)"color", (Matcher)CoreMatchers.is((Object)"RED")), (Matcher)Matchers.hasProperty((String)"price", (Matcher)CoreMatchers.is((Object)1000)))));
    }

    @Test
    public void getMapFromJsonCar() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload]", DataType.fromType(Map.class));
        Map car = (Map)attributeEvaluator.resolveValue(this.newEvent(JSON_CAR, MediaType.APPLICATION_JSON));
        MatcherAssert.assertThat((Object)car, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"price"), (Matcher)CoreMatchers.is((Object)1000)));
        MatcherAssert.assertThat((Object)car, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"color"), (Matcher)CoreMatchers.is((Object)"RED")));
    }

    @Test
    public void getListOfCarsFromJsonCar() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[[payload]]", CAR_LIST_DATA_TYPE);
        List cars = (List)attributeEvaluator.resolveValue(this.newEvent(JSON_CAR, MediaType.APPLICATION_JSON));
        Car car = (Car)cars.get(0);
        MatcherAssert.assertThat((Object)car, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasProperty((String)"color", (Matcher)CoreMatchers.is((Object)"RED")), (Matcher)Matchers.hasProperty((String)"price", (Matcher)CoreMatchers.is((Object)1000)))));
    }

    @Test
    public void getListOfCarsFromExpression() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator(DW_CAR_LIST, CAR_LIST_DATA_TYPE);
        List cars = (List)attributeEvaluator.resolveValue(this.newEvent(JSON_CAR, MediaType.APPLICATION_JSON));
        Car car = (Car)cars.get(0);
        MatcherAssert.assertThat((Object)car, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasProperty((String)"color", (Matcher)CoreMatchers.is((Object)"RED")), (Matcher)Matchers.hasProperty((String)"price", (Matcher)CoreMatchers.is((Object)1000)))));
    }

    @Test
    public void getListOfMapsFromJsonCar() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[[payload as Object]]", DataType.fromType(List.class));
        List cars = (List)attributeEvaluator.resolveValue(this.newEvent(JSON_CAR, MediaType.APPLICATION_JSON));
        Map car = (Map)cars.get(0);
        MatcherAssert.assertThat((Object)car, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"price"), (Matcher)CoreMatchers.is((Object)1000)));
        MatcherAssert.assertThat((Object)car, (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"color"), (Matcher)CoreMatchers.is((Object)"RED")));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void parseExpressionAreNotSupported() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("invalid #['expression']");
        attributeEvaluator.resolveValue(this.newEvent());
    }

    @Test
    public void resolveIntegerValueFromJsonObject() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.port]", DataType.NUMBER);
        Integer port = (Integer)attributeEvaluator.resolveValue(this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON));
        MatcherAssert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)8081));
    }

    @Test
    public void resolveIntegerValueFromJavaString() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload]", DataType.NUMBER);
        Object port = attributeEvaluator.resolveValue(this.newEvent("12", MediaType.APPLICATION_JAVA));
        MatcherAssert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)12));
    }

    @Test
    public void resolveStringValue() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.port]", DataType.STRING);
        String port = (String)attributeEvaluator.resolveValue(this.newEvent(HOST_PORT_JSON, MediaType.APPLICATION_JSON));
        MatcherAssert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)"8081"));
    }

    @Test
    public void getBooleanValue() throws MuleException {
        AttributeEvaluator attributeEvaluator = this.getAttributeEvaluator("#[payload.ok]", DataType.BOOLEAN);
        Boolean bool = (Boolean)attributeEvaluator.resolveValue(this.newEvent("{\"ok\" : true}", MediaType.APPLICATION_JSON));
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Object)true));
    }

    private Event newEvent(Object payload, MediaType applicationJson) throws MuleException {
        return Event.builder((Event)this.newEvent()).message(Message.builder().payload(payload).mediaType(applicationJson).build()).build();
    }

    private AttributeEvaluator getAttributeEvaluator(String expression) {
        return this.getAttributeEvaluator(expression, null);
    }

    private AttributeEvaluator getAttributeEvaluator(String expression, DataType expectedDataType) {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(expression, expectedDataType);
        attributeEvaluator.initialize((ExtendedExpressionManager)this.expressionManager);
        return attributeEvaluator;
    }
}

