/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ExceptionUtilsTestCase
extends AbstractMuleTestCase {
    private static final String ERROR_MESSAGE = "Excepted Error Message";

    @Test
    public void testContainsType() {
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new IllegalArgumentException(), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException()), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), NullPointerException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), RuntimeException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), Exception.class));
        Assert.assertFalse((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), IOException.class));
    }

    @Test
    public void testLastIndexOfType_deepestIsTheOneWeWant() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something");
        this.assertExpectationsForDeepestOccurence(expected);
    }

    @Test
    public void testLastIndexOfType_theOneWeWantIsNotTheDeepest() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something", new NullPointerException("somenull"));
        this.assertExpectationsForDeepestOccurence(expected);
    }

    private void assertExpectationsForDeepestOccurence(IllegalArgumentException expected) {
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurrenceOfType((Throwable)expected, IllegalArgumentException.class));
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurrenceOfType((Throwable)new Exception(expected), IllegalArgumentException.class));
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurrenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IllegalArgumentException.class));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurrenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IOException.class));
    }

    @Test
    public void testLastIndexOfType_nullParameters() throws Exception {
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurrenceOfType(null, null));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurrenceOfType((Throwable)new Exception(), null));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurrenceOfType(null, Exception.class));
    }

    @Test
    public void testFullStackTraceWithoutMessage() throws Exception {
        String mainMessage = "main message 112312 [][] ''' ... sdfsd blah";
        String causeMessage = "cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki";
        RuntimeException e = new RuntimeException("main message 112312 [][] ''' ... sdfsd blah", new RuntimeException("cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki"));
        String withoutMessage = ExceptionUtils.getFullStackTraceWithoutMessages((Throwable)e);
        String fullStackTrace = org.apache.commons.lang.exception.ExceptionUtils.getFullStackTrace((Throwable)e);
        String[] linesWithoutMessage = withoutMessage.split(SystemUtils.LINE_SEPARATOR);
        String[] lines = fullStackTrace.split(SystemUtils.LINE_SEPARATOR);
        Assert.assertEquals((long)lines.length, (long)linesWithoutMessage.length);
        for (int i = 0; i < lines.length; ++i) {
            Assert.assertTrue((boolean)lines[i].contains(linesWithoutMessage[i]));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains("main message 112312 [][] ''' ... sdfsd blah"));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains("cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki"));
        }
    }

    @Test
    public void extractExceptionOfType() {
        Exception exception = new Exception(new Throwable(new ConnectionException((Throwable)new IOException(new NullPointerException()))));
        Optional ioException = ExceptionUtils.extractOfType((Throwable)exception, IOException.class);
        Assert.assertThat((Object)ioException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IOException)ioException.get()).getCause(), (Matcher)IsInstanceOf.instanceOf(NullPointerException.class));
    }

    @Test
    public void extractExceptionOfSubtype() {
        Exception exception = new Exception(new IllegalStateException(new Error(new RuntimeException(new IOException()))));
        Optional runtimeException = ExceptionUtils.extractOfType((Throwable)exception, RuntimeException.class);
        Assert.assertThat((Object)runtimeException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(runtimeException.get(), (Matcher)IsInstanceOf.instanceOf(IllegalStateException.class));
    }

    @Test
    public void extractExceptionCauseOf() {
        Exception exception = new Exception(new IOException(new ConnectionException(ERROR_MESSAGE, (Throwable)new NullPointerException())));
        Optional throwable = ExceptionUtils.extractCauseOfType((Throwable)exception, IOException.class);
        Assert.assertThat((Object)throwable.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(throwable.get(), (Matcher)IsInstanceOf.instanceOf(ConnectionException.class));
        Assert.assertThat((Object)((Throwable)throwable.get()).getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void extractRootConnectionException() {
        Exception withConnectionExceptionCause = new Exception(new ConnectionException(ERROR_MESSAGE, (Throwable)new ConnectionException((Throwable)new NullPointerException())));
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)withConnectionExceptionCause);
        Assert.assertThat((Object)connectionException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((ConnectionException)((Object)connectionException.get())).getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void extractMissingConnectionException() {
        Exception withoutConnectionException = new Exception(new NullPointerException());
        Optional exception = ExceptionUtils.extractConnectionException((Throwable)withoutConnectionException);
        Assert.assertThat((Object)exception.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void updateMessaginExceptionWithErrorWithOutError() {
        MessagingException messagingExceptionMock = (MessagingException)((Object)Mockito.mock(MessagingException.class));
        Processor processorMock = (Processor)Mockito.mock(Processor.class);
        FlowConstruct flowConstructMock = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        MuleContext muleContextMock = (MuleContext)Mockito.mock(MuleContext.class);
        ErrorTypeLocator errorTypeLocatorMock = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        Event eventMock = (Event)Mockito.mock(Event.class);
        FlowCallStack flowCallStackMock = (FlowCallStack)Mockito.mock(FlowCallStack.class);
        Message messageMock = (Message)Mockito.mock(Message.class);
        EventContext eventContextMock = (EventContext)Mockito.mock(EventContext.class);
        Optional<Object> errorOptional = Optional.ofNullable(null);
        Mockito.when((Object)messagingExceptionMock.getEvent()).thenReturn((Object)eventMock);
        Mockito.when((Object)eventMock.getError()).thenReturn(errorOptional);
        Mockito.when((Object)eventMock.getFlowCallStack()).thenReturn((Object)flowCallStackMock);
        Mockito.when((Object)eventMock.getMessage()).thenReturn((Object)messageMock);
        Mockito.when((Object)eventMock.getContext()).thenReturn((Object)eventContextMock);
        Mockito.when((Object)eventContextMock.getId()).thenReturn((Object)"someid");
        Mockito.when((Object)flowConstructMock.getMuleContext()).thenReturn((Object)muleContextMock);
        Mockito.when((Object)muleContextMock.getErrorTypeLocator()).thenReturn((Object)errorTypeLocatorMock);
        Mockito.when((Object)errorTypeLocatorMock.lookupErrorType((Throwable)messagingExceptionMock)).thenReturn(Mockito.mock(ErrorType.class));
        ExceptionUtils.updateMessagingExceptionWithError((MessagingException)messagingExceptionMock, (Processor)processorMock, (FlowConstruct)flowConstructMock);
        ((MessagingException)((Object)Mockito.verify((Object)((Object)messagingExceptionMock), (VerificationMode)Mockito.atLeast((int)1)))).setProcessedEvent((Event)Matchers.any(Event.class));
    }

    @Test
    public void updateMessaginExceptionWithError() {
        MessagingException messagingExceptionMock = (MessagingException)((Object)Mockito.mock(MessagingException.class));
        Processor processorMock = (Processor)Mockito.mock(Processor.class);
        FlowConstruct flowConstructMock = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        MuleContext muleContextMock = (MuleContext)Mockito.mock(MuleContext.class);
        ErrorTypeLocator errorTypeLocatorMock = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        Event eventMock = (Event)Mockito.mock(Event.class);
        FlowCallStack flowCallStackMock = (FlowCallStack)Mockito.mock(FlowCallStack.class);
        Message messageMock = (Message)Mockito.mock(Message.class);
        EventContext eventContextMock = (EventContext)Mockito.mock(EventContext.class);
        org.mule.runtime.api.message.Error errorMock = (org.mule.runtime.api.message.Error)Mockito.mock(org.mule.runtime.api.message.Error.class);
        Optional<org.mule.runtime.api.message.Error> errorOptional = Optional.ofNullable(errorMock);
        Mockito.when((Object)messagingExceptionMock.getEvent()).thenReturn((Object)eventMock);
        Mockito.when((Object)eventMock.getError()).thenReturn(errorOptional);
        Mockito.when((Object)eventMock.getFlowCallStack()).thenReturn((Object)flowCallStackMock);
        Mockito.when((Object)eventMock.getMessage()).thenReturn((Object)messageMock);
        Mockito.when((Object)eventMock.getContext()).thenReturn((Object)eventContextMock);
        Mockito.when((Object)eventContextMock.getId()).thenReturn((Object)"someid");
        Mockito.when((Object)flowConstructMock.getMuleContext()).thenReturn((Object)muleContextMock);
        Mockito.when((Object)muleContextMock.getErrorTypeLocator()).thenReturn((Object)errorTypeLocatorMock);
        Mockito.when((Object)errorTypeLocatorMock.lookupErrorType((Throwable)messagingExceptionMock)).thenReturn(Mockito.mock(ErrorType.class));
        ExceptionUtils.updateMessagingExceptionWithError((MessagingException)messagingExceptionMock, (Processor)processorMock, (FlowConstruct)flowConstructMock);
        ((MessagingException)((Object)Mockito.verify((Object)((Object)messagingExceptionMock), (VerificationMode)Mockito.times((int)0)))).setProcessedEvent((Event)Matchers.any(Event.class));
    }
}

