/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.util.monitor.Expirable;
import org.mule.runtime.core.util.monitor.ExpiryMonitor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class ExpiryMonitorTestCase
extends AbstractMuleContextTestCase {
    private static final int EXPIRE_TIME = 300;
    private static final int EXPIRE_INTERVAL = 100;
    private static final int EXPIRE_TIMEOUT = 600;
    private static final long DELTA_TIME = 10L;
    private volatile boolean expired = false;
    private volatile long expiredTime = -1L;
    private ExpiryMonitor monitor;

    @Before
    public void before() throws Exception {
        this.expired = false;
        this.monitor = new ExpiryMonitor("test", 100L, muleContext, false);
    }

    @After
    public void after() {
        this.monitor.dispose();
    }

    @Test
    public void testExpiry() throws InterruptedException {
        Expirable e = () -> this.expire();
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        new PollingProber(600L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.monitor.isRegistered(e), (Matcher)Matchers.is((Object)false));
            return true;
        }, () -> "" + System.currentTimeMillis() + " - " + this.monitor.toString()));
    }

    @Test
    public void testNotExpiry() throws InterruptedException {
        Expirable e = () -> this.expire();
        long startTime = System.currentTimeMillis();
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)false));
        new PollingProber(600L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.monitor.isRegistered(e), (Matcher)Matchers.is((Object)false));
            return true;
        }, () -> "" + System.currentTimeMillis() + " - " + this.monitor.toString()));
        Assert.assertThat((Object)(this.expiredTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(290L)));
    }

    @Test
    public void testExpiryWithReset() throws InterruptedException {
        Expirable e = () -> this.expire();
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)false));
        long startTime = System.currentTimeMillis();
        this.monitor.resetExpirable(e);
        this.monitor.run();
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        new PollingProber(600L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.monitor.isRegistered(e), (Matcher)Matchers.is((Object)false));
            return true;
        }, () -> "" + System.currentTimeMillis() + " - " + this.monitor.toString()));
        Assert.assertThat((Object)(this.expiredTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(290L)));
    }

    @Test
    public void testNotExpiryWithRemove() throws InterruptedException {
        Expirable e = () -> this.expire();
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)false));
        this.monitor.removeExpirable(e);
        Thread.sleep(600L);
        Assert.assertThat((Object)this.expired, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.monitor.isRegistered(e), (Matcher)Matchers.is((Object)false));
    }

    private void expire() {
        this.expiredTime = System.currentTimeMillis();
        this.expired = true;
    }
}

