/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.IOException;
import java.util.HashMap;
import javax.activation.MimetypesFileTypeMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class FileExtensionContentTypeResolutionTestCase
extends AbstractMuleTestCase {
    private static final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.BINARY;

    @Test
    public void resolvesFileMimeType() throws Exception {
        HashMap<String, MediaType> mimeTypes = new HashMap<String, MediaType>();
        mimeTypes.put("txt", MediaType.TEXT);
        mimeTypes.put("json", MediaType.JSON);
        mimeTypes.put("xml", MediaType.XML);
        mimeTypes.put("html", MediaType.HTML);
        mimeTypes.put("csv", MediaType.create((String)"text", (String)"csv"));
        for (String extension : mimeTypes.keySet()) {
            this.doFileMimeTypeTest(extension, (MediaType)mimeTypes.get(extension));
        }
    }

    @Test
    public void resolvesDefaultMimeType() throws Exception {
        this.doFileMimeTypeTest("xxxxxx", DEFAULT_CONTENT_TYPE);
    }

    private void doFileMimeTypeTest(String fileExtension, MediaType expectedMimeType) throws IOException {
        String filename = "test." + fileExtension;
        String mimeType = mimetypesFileTypeMap.getContentType(filename);
        MatcherAssert.assertThat((Object)mimeType, (Matcher)CoreMatchers.equalTo((Object)expectedMimeType.toString()));
    }
}

