/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.ZipUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FileUtilsTestCase
extends AbstractMuleTestCase {
    private static final String TEST_FILE = "testFile.txt";
    private static final String TEST_DIRECTORY = "target" + File.separator + "testDirectory";
    private static final String UNZIPPED_FILE_PATH = TEST_DIRECTORY + File.separator + "testFolder" + File.separator + "testFile.txt";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File toDir;

    @Before
    public void setupDir() {
        this.toDir = this.temporaryFolder.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTools() throws Exception {
        File file = null;
        try {
            file = org.mule.runtime.core.api.util.FileUtils.stringToFile((String)TEST_FILE, (String)"this is a test file");
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)file.exists());
            file = org.mule.runtime.core.api.util.FileUtils.stringToFile((String)TEST_FILE, (String)" and this is appended content", (boolean)true);
            String content = FileUtils.readFileToString((File)org.mule.runtime.core.api.util.FileUtils.newFile((String)TEST_FILE), (String)null);
            Assert.assertNotNull((Object)content);
            Assert.assertTrue((content.indexOf("this is a test file") > -1 ? 1 : 0) != 0);
            Assert.assertTrue((content.indexOf(" and this is appended content") > -1 ? 1 : 0) != 0);
            file = org.mule.runtime.core.api.util.FileUtils.newFile((String)TEST_FILE);
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)file.exists());
            file = org.mule.runtime.core.api.util.FileUtils.createFile((String)TEST_FILE);
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)file.exists());
            file = org.mule.runtime.core.api.util.FileUtils.createFile((String)"testFile.txt2");
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)file.exists());
            Assert.assertTrue((boolean)file.canRead());
            file.delete();
            file = org.mule.runtime.core.api.util.FileUtils.newFile((String)TEST_FILE);
            file.delete();
            File dir = org.mule.runtime.core.api.util.FileUtils.openDirectory((String)"src");
            Assert.assertNotNull((Object)dir);
            Assert.assertTrue((boolean)dir.exists());
            Assert.assertTrue((boolean)dir.canRead());
            Assert.assertTrue((boolean)dir.isDirectory());
            dir = org.mule.runtime.core.api.util.FileUtils.openDirectory((String)"doesNotExist");
            Assert.assertNotNull((Object)dir);
            Assert.assertTrue((boolean)dir.exists());
            Assert.assertTrue((boolean)dir.canRead());
            Assert.assertTrue((boolean)dir.isDirectory());
            dir.delete();
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Test
    public void testFileNameTools() throws Exception {
        String filename = "Blah<Blah>.txt";
        String result = org.mule.runtime.core.api.util.FileUtils.prepareWinFilename((String)filename);
        Assert.assertEquals((Object)"Blah(Blah).txt", (Object)result);
        filename = "Bla]h<Blah:a;b|c?d=e_f*g>.txt";
        result = org.mule.runtime.core.api.util.FileUtils.prepareWinFilename((String)filename);
        Assert.assertEquals((Object)"Bla-h(Blah-a-b-c-d=e_f-g).txt", (Object)result);
        filename = "B\"la-h<Blah:a;b|c?d=e_f*g>.txt";
        result = org.mule.runtime.core.api.util.FileUtils.prepareWinFilename((String)filename);
        Assert.assertEquals((Object)"B-la-h(Blah-a-b-c-d=e_f-g).txt", (Object)result);
    }

    @Test
    public void testDirectoryTools() throws Exception {
        File dir = org.mule.runtime.core.api.util.FileUtils.openDirectory((String)"src");
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.canRead());
        Assert.assertTrue((boolean)dir.isDirectory());
        dir = org.mule.runtime.core.api.util.FileUtils.openDirectory((String)"doesNotExist");
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.canRead());
        Assert.assertTrue((boolean)dir.isDirectory());
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)dir);
    }

    @Test
    public void testExtractResource() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-1";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            Assert.assertTrue((String)"Failed to create output dirs.", (boolean)outputDir.mkdirs());
        }
        String res = "META-INF/MANIFEST.MF";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, ((Object)((Object)this)).getClass(), (File)outputDir, (boolean)true);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)res);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractResources() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-2";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "META-INF/";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, ((Object)((Object)this)).getClass(), (File)outputDir, (boolean)true);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)res);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isDirectory());
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractFileResource() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-3";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "org/mule/runtime/core/api/util/FileUtils.class";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, org.mule.runtime.core.api.util.FileUtils.class, (File)outputDir, (boolean)true);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)res);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractFileResources() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-4";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "org/mule/runtime/core/util/";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, org.mule.runtime.core.api.util.FileUtils.class, (File)outputDir, (boolean)true);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)res);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isDirectory());
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractResourceWithoutKeepingDirStructure() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-5";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "MANIFEST.MF";
        String res = "META-INF/" + fileName;
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, ((Object)((Object)this)).getClass(), (File)outputDir, (boolean)false);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)fileName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractResourcesWithoutKeepingDirStructure() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-6";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "util/FileUtilsTestCase.class";
        String res = "org/mule/runtime/core";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, FileUtilsTestCase.class, (File)outputDir, (boolean)false);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)fileName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractFileResourceWithoutKeepingDirStructure() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-7";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "FileUtils.class";
        String res = "org/mule/runtime/core/api/util/" + fileName;
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, org.mule.runtime.core.api.util.FileUtils.class, (File)outputDir, (boolean)false);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)fileName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testExtractFileResourcesWithoutKeepingDirStructure() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-8";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "util/FileUtilsTestCase.class";
        String res = "org/mule/runtime/core/";
        org.mule.runtime.core.api.util.FileUtils.extractResources((String)res, FileUtilsTestCase.class, (File)outputDir, (boolean)false);
        File result = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir, (String)fileName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.exists());
        Assert.assertTrue((boolean)result.canRead());
        Assert.assertTrue((boolean)result.isFile());
        Assert.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testDeleteTreeWithIgnoredDirectories() throws Exception {
        String testDir = TEST_DIRECTORY + File.separator + "Test-deleting";
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File toBeDeleted1 = org.mule.runtime.core.api.util.FileUtils.newFile((File)outputDir, (String)"toBeDeleted1/");
        toBeDeleted1.mkdirs();
        File toBeDeleted2 = org.mule.runtime.core.api.util.FileUtils.newFile((File)outputDir, (String)"toBeDeleted2/");
        toBeDeleted2.mkdirs();
        File keepMeIntact = org.mule.runtime.core.api.util.FileUtils.newFile((File)outputDir, (String)"keepMeIntact/");
        keepMeIntact.mkdirs();
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir, (String[])new String[]{"keepMeIntact"});
        Assert.assertTrue((String)"Shouldn't have been deleted.", (boolean)keepMeIntact.exists());
        org.mule.runtime.core.api.util.FileUtils.deleteTree((File)outputDir);
    }

    @Test
    public void testRenameFile() {
        try {
            File sourceFile = this.createTestFile("source");
            File destFile = this.createTestFile("dest");
            Assert.assertTrue((boolean)destFile.delete());
            Assert.assertTrue((boolean)org.mule.runtime.core.api.util.FileUtils.renameFile((File)sourceFile, (File)destFile));
            Assert.assertTrue((boolean)destFile.exists());
            Assert.assertTrue((boolean)destFile.delete());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRenameFileAcrossFolders() {
        try {
            File dir = this.createTestDir("test");
            File sourceFile = this.createTestFile("source");
            File destFile = new File(dir, "dest");
            Assert.assertTrue((boolean)org.mule.runtime.core.api.util.FileUtils.renameFile((File)sourceFile, (File)destFile));
            Assert.assertTrue((boolean)destFile.exists());
            Assert.assertTrue((boolean)destFile.delete());
            Assert.assertTrue((boolean)dir.delete());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnzipFileToSameFolderTwice() throws Exception {
        URL resourceAsUrl = IOUtils.getResourceAsUrl((String)"testFolder.zip", ((Object)((Object)this)).getClass());
        File zipFile = new File(resourceAsUrl.toURI());
        File outputDir = org.mule.runtime.core.api.util.FileUtils.newFile((String)TEST_DIRECTORY);
        for (int i = 0; i < 2; ++i) {
            org.mule.runtime.core.api.util.FileUtils.unzip((File)zipFile, (File)outputDir);
            File testFile = new File(UNZIPPED_FILE_PATH);
            Assert.assertTrue((boolean)testFile.exists());
        }
    }

    @Test
    public void unzipsFileWithoutParentFolderEntry() throws Exception {
        String resourceName = "dummy.xml";
        String resourceAlias = "folder" + File.separator + "dummy.xml";
        File compressedFile = new File(this.toDir, "test.zip");
        ZipUtils.compress((File)compressedFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource("dummy.xml", resourceAlias)});
        org.mule.runtime.core.api.util.FileUtils.unzip((File)compressedFile, (File)this.toDir);
        Assert.assertThat((Object)new File(new File(this.toDir, "folder"), "dummy.xml").exists(), (Matcher)Matchers.is((Object)true));
    }

    private File createTestFile(String filePath) throws IOException {
        return File.createTempFile(filePath, ".junit");
    }

    private File createTestDir(String dirPath) throws IOException {
        File file = this.createTestFile(dirPath);
        file.delete();
        file.mkdir();
        return file;
    }
}

