/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;

@SmallTest
@RunWith(value=Parameterized.class)
public class GetArrayLengthTestCase
extends AbstractMuleTestCase {
    private final Object unaryArray;
    private final Object emptyArray;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new Object[]{new Apple()}, new Object[0]}, {new Apple[]{new Apple()}, new Apple[0]}, {new boolean[]{true}, new boolean[0]}, {new byte[]{0}, new byte[0]}, {new char[]{'0'}, new char[0]}, {new short[]{0}, new short[0]}, {new int[]{0}, new int[0]}, {new long[]{0L}, new long[0]}, {new float[]{0.0f}, new float[0]}, {new double[]{0.0}, new double[0]}, {new String[]{""}, new String[0]}, {new String[]{""}, null});
    }

    public GetArrayLengthTestCase(Object unaryArray, Object emptyArray) {
        this.unaryArray = unaryArray;
        this.emptyArray = emptyArray;
    }

    @Test
    public void unaryArray() {
        Assert.assertThat((Object)ArrayUtils.getLength((Object)this.unaryArray), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void emptyArray() {
        Assert.assertThat((Object)ArrayUtils.getLength((Object)this.emptyArray), (Matcher)CoreMatchers.is((Object)0));
    }
}

