/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.lang.reflect.Field;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.internal.util.JdkVersionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class JdkVersionUtilsTestCase
extends AbstractMuleTestCase {
    private String originalJavaVersion;
    private Manifest originalManifest;

    @Before
    public void before() {
        this.originalJavaVersion = System.getProperty("java.version");
        this.originalManifest = MuleManifest.getManifest();
    }

    @After
    public void after() throws Exception {
        JdkVersionUtilsTestCase.setJdkVersion(this.originalJavaVersion);
        this.setManifest(this.originalManifest);
    }

    private static void setJdkVersion(String version) {
        System.setProperty("java.version", version);
    }

    private void setManifest(Manifest manifest) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = MuleManifest.class.getDeclaredField("manifest");
        field.setAccessible(true);
        field.set(null, manifest);
    }

    @Test
    public void testIsSupportedJdkVersion() {
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0");
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8.20");
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0_129");
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.7.2");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.7.2_12");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.9");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
    }

    @Test
    public void testUndefinedJdkPreferences() throws Exception {
        JdkVersionUtilsTestCase.setJdkVersion("1.4.2");
        this.setJdkPreferences("");
        Assert.assertEquals((Object)"", (Object)JdkVersionUtils.getRecommendedJdks());
        Assert.assertEquals((Object)"", (Object)JdkVersionUtils.getSupportedJdks());
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVendor());
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        this.setJdkPreferences(null);
        Assert.assertNull((Object)JdkVersionUtils.getRecommendedJdks());
        Assert.assertNull((Object)JdkVersionUtils.getSupportedJdks());
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVendor());
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
    }

    private void setJdkPreferences(String preference) throws Exception {
        Manifest manifest = (Manifest)Mockito.mock(Manifest.class);
        Attributes attributes = (Attributes)Mockito.mock(Attributes.class);
        Mockito.when((Object)attributes.getValue((Attributes.Name)Mockito.any(Attributes.Name.class))).thenReturn((Object)preference);
        Mockito.when((Object)manifest.getMainAttributes()).thenReturn((Object)attributes);
        this.setManifest(manifest);
    }

    @Test
    public void testSupportedJdkVendor() {
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVendor());
    }

    @Test
    public void testRecommendedJdkVersion() {
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0_129");
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8.20");
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.4.2");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.6");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.6.0_5");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.7.0");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.9");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
    }

    @Test
    public void testJdkVersion() {
        JdkVersionUtils.JdkVersion jdkVersion = new JdkVersionUtils.JdkVersion("1.7");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(7), (Object)jdkVersion.getMinor());
        Assert.assertNull((Object)jdkVersion.getMicro());
        Assert.assertNull((Object)jdkVersion.getUpdate());
        Assert.assertNull((Object)jdkVersion.getMilestone());
        jdkVersion = new JdkVersionUtils.JdkVersion("1.7.0-ea");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(7), (Object)jdkVersion.getMinor());
        Assert.assertEquals((Object)new Integer(0), (Object)jdkVersion.getMicro());
        Assert.assertNull((Object)jdkVersion.getUpdate());
        Assert.assertEquals((Object)"ea", (Object)jdkVersion.getMilestone());
        jdkVersion = new JdkVersionUtils.JdkVersion("1.6.0_29-b05");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(6), (Object)jdkVersion.getMinor());
        Assert.assertEquals((Object)new Integer(0), (Object)jdkVersion.getMicro());
        Assert.assertEquals((Object)new Integer(29), (Object)jdkVersion.getUpdate());
        Assert.assertEquals((Object)"b05", (Object)jdkVersion.getMilestone());
    }

    @Test
    public void testJdkVersionComparison() {
        JdkVersionUtils.JdkVersion jdk1_3 = new JdkVersionUtils.JdkVersion("1.3");
        JdkVersionUtils.JdkVersion jdk1_6_0_5 = new JdkVersionUtils.JdkVersion("1.6.0_5");
        JdkVersionUtils.JdkVersion jdk1_7 = new JdkVersionUtils.JdkVersion("1.7");
        JdkVersionUtils.JdkVersion jdk1_6_0_29 = new JdkVersionUtils.JdkVersion("1.6.0_29");
        JdkVersionUtils.JdkVersion jdk1_6_0_29_b04 = new JdkVersionUtils.JdkVersion("1.6.0_29-b04");
        JdkVersionUtils.JdkVersion jdk1_6_0_29_b05 = new JdkVersionUtils.JdkVersion("1.6.0_29-b05");
        Assert.assertTrue((jdk1_3.compareTo(jdk1_7) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_7.compareTo(jdk1_3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_3.compareTo(jdk1_3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b05.compareTo(jdk1_6_0_29_b05) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_5.compareTo(jdk1_6_0_29_b04) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_6_0_5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29.compareTo(jdk1_6_0_5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_5.compareTo(jdk1_6_0_29) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29.compareTo(jdk1_6_0_29_b04) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_6_0_29) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_6_0_29_b05) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b05.compareTo(jdk1_6_0_29_b04) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_7) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_7.compareTo(jdk1_6_0_29_b04) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testValidateJdk() {
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0");
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0_129");
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.8.20");
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.9.0");
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.9.0_03");
        JdkVersionUtils.validateJdk();
        JdkVersionUtilsTestCase.setJdkVersion("1.9.0_51");
        JdkVersionUtils.validateJdk();
    }

    @Test(expected=RuntimeException.class)
    public void testValidateJdk5() {
        JdkVersionUtilsTestCase.setJdkVersion("1.5.1");
        JdkVersionUtils.validateJdk();
    }

    @Test
    public void testValidateJdk8() {
        JdkVersionUtilsTestCase.setJdkVersion("1.8.0");
        JdkVersionUtils.validateJdk();
    }
}

