/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.util.AttributeEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MELAttributeEvaluatorTestCase
extends AbstractMuleTestCase {
    private ExtendedExpressionManager mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
    private Event event = (Event)Mockito.mock(Event.class);

    @Test
    public void plainTextValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("attributeEvaluator");
        Mockito.when((Object)this.mockExpressionManager.isExpression("attributeEvaluator")).thenReturn((Object)false);
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void expressionValue() {
        String attributeValue = "#[mel:eval:express]";
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)attributeValue), (Event)Matchers.any(Event.class))).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void expressionValueNoEvaluator() {
        String attributeValue = "#[mel:express]";
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)attributeValue), (Event)Matchers.any(Event.class))).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        Mockito.when((Object)this.mockExpressionManager.isExpression(attributeValue)).thenReturn((Object)true);
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void parse() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("1#[mel:2]3#[mel:4]5");
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void testParseStartsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:1]234#[mel:5]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void parseStartsAndEndsWithExpression() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:1]#[mel:2]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void parenthesesInExpression() {
        Mockito.when((Object)this.mockExpressionManager.evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class))).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:(1)]");
        attributeEvaluator.initialize(this.mockExpressionManager);
        attributeEvaluator.resolveValue(this.event);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }

    @Test
    public void resolveIntegerWithNumericStringValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:expression]", DataType.NUMBER);
        attributeEvaluator.initialize(this.mockExpressionManager);
        String expectedValue = "123";
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)Integer.parseInt("123"), DataType.NUMBER)).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)attributeEvaluator.resolveValue(this.event), (Matcher)Is.is((Object)Integer.parseInt("123")));
    }

    @Test
    public void resolveIntegerWithNumericValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:expression]", DataType.NUMBER);
        attributeEvaluator.initialize(this.mockExpressionManager);
        long expectedValue = 1234L;
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)1234L, DataType.fromObject((Object)1234L))).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)attributeEvaluator.resolveValue(this.event), (Matcher)Is.is((Object)1234L));
    }

    @Test
    public void resolveBooleanWithBooleanStringValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:expression]", DataType.BOOLEAN);
        attributeEvaluator.initialize(this.mockExpressionManager);
        String expectedValue = "true";
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)Boolean.valueOf("true"), DataType.BOOLEAN)).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)attributeEvaluator.resolveValue(this.event), (Matcher)Is.is((Object)Boolean.valueOf("true")));
    }

    @Test
    public void resolveBooleanWithBooleanValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:expression]", DataType.BOOLEAN);
        attributeEvaluator.initialize(this.mockExpressionManager);
        Boolean expectedValue = true;
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)expectedValue, DataType.fromObject((Object)expectedValue))).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)attributeEvaluator.resolveValue(this.event), (Matcher)Is.is((Object)expectedValue));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void resolveIntegerWithNoNumericValue() {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator("#[mel:expression]", DataType.NUMBER);
        attributeEvaluator.initialize(this.mockExpressionManager);
        ((ExtendedExpressionManager)Mockito.doThrow(ExpressionRuntimeException.class).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        attributeEvaluator.resolveValue(this.event);
    }

    @Test
    public void nullAttributeValue() {
        AttributeEvaluator nullAttributeEvaluator = new AttributeEvaluator(null, DataType.OBJECT);
        nullAttributeEvaluator.initialize(this.mockExpressionManager);
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue(null, DataType.OBJECT)).when((Object)this.mockExpressionManager)).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(BindingContext.class), (Event)Matchers.any(Event.class));
        Assert.assertThat((Object)nullAttributeEvaluator.resolveValue(this.event), (Matcher)IsNull.nullValue());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any());
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (Event)Matchers.any(Event.class));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.mockExpressionManager, (VerificationMode)Mockito.never())).evaluate(Matchers.anyString(), (DataType)Matchers.any(DataType.class), (BindingContext)Matchers.any(), (Event)Matchers.any(Event.class));
    }
}

