/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.util.StandaloneServerUtils;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StandaloneServerUtilsTestCase
extends AbstractMuleTestCase {
    private static final String EXPECTED_MULE_HOME_VALUE = "expected-mule-home-value";
    private static final String EXPECTED_MULE_BASE_VALUE = "expected-mule-base-value";

    @Test
    public void muleHome() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.home", (String)EXPECTED_MULE_HOME_VALUE, () -> Assert.assertThat((Object)((File)StandaloneServerUtils.getMuleHome().get()).getName(), (Matcher)Is.is((Object)EXPECTED_MULE_HOME_VALUE)));
    }

    @Test
    public void muleHomeIsNullWhenNotDefined() throws Exception {
        Assert.assertThat((Object)StandaloneServerUtils.getMuleHome().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void muleBase() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.base", (String)EXPECTED_MULE_BASE_VALUE, () -> Assert.assertThat((Object)((File)StandaloneServerUtils.getMuleBase().get()).getName(), (Matcher)Is.is((Object)EXPECTED_MULE_BASE_VALUE)));
    }

    @Test
    public void muleBaseReturnsMuleHomeWhenNotSet() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.home", (String)EXPECTED_MULE_HOME_VALUE, () -> Assert.assertThat((Object)((File)StandaloneServerUtils.getMuleBase().get()).getName(), (Matcher)Is.is((Object)EXPECTED_MULE_HOME_VALUE)));
    }

    @Test
    public void muleBaseReturnsNullIfNetherMuleHomeOrMuleBaseIsSet() throws Exception {
        Assert.assertThat((Object)StandaloneServerUtils.getMuleBase().isPresent(), (Matcher)Is.is((Object)false));
    }
}

