/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue;

import java.io.Serializable;
import org.apache.commons.lang.NotImplementedException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionRecoverer;
import org.mule.runtime.core.internal.util.queue.PersistentQueueTransactionContext;
import org.mule.runtime.core.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.util.queue.DefaultQueueStore;
import org.mule.runtime.core.util.queue.QueueProvider;
import org.mule.runtime.core.util.queue.QueueStore;
import org.mule.runtime.core.util.queue.RecoverableQueueStore;
import org.mule.runtime.core.util.queue.TestTransactionLogger;
import org.mule.runtime.core.util.xa.ResourceManagerException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class LocalTxQueueTransactionRecovererTestCase
extends AbstractMuleContextTestCase {
    public static final String QUEUE_NAME = "inQueue";
    private static final int TIMEOUT = 10;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private LocalTxQueueTransactionJournal txLog;
    private DefaultQueueStore inQueue;
    private PersistentQueueTransactionContext persistentTransactionContext;
    private LocalTxQueueTransactionRecoverer queueTransactionRecoverer;

    protected void doSetUp() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.inQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(this.inQueue));
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(this.inQueue));
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        muleConfiguration.setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
    }

    @Test
    public void pollAndFailThenRecover() throws Exception {
        this.inQueue.offer((Serializable)this.testEvent(), 0, 10L);
        Serializable value = this.persistentTransactionContext.poll((QueueStore)this.inQueue, 100000L);
        Assert.assertThat((Object)this.inQueue.poll(10L), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        Event muleEvent = (Event)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.testEvent().getContext().getId(), (Matcher)CoreMatchers.equalTo((Object)muleEvent.getContext().getId()));
    }

    @Test
    public void pollAndFailThenRecoverWithTwoElements() throws Exception {
        String MESSAGE_CONTENT_2 = "test2";
        Event testEvent2 = LocalTxQueueTransactionRecovererTestCase.eventBuilder().message(Message.of((Object)"test2")).build();
        this.inQueue.offer((Serializable)this.testEvent(), 0, 10L);
        this.inQueue.offer((Serializable)testEvent2, 0, 10L);
        Serializable value = this.persistentTransactionContext.poll((QueueStore)this.inQueue, 100000L);
        Assert.assertThat((Object)this.inQueue.getSize(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        Event muleEvent = (Event)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)muleEvent.getMessage().getPayload().getValue().toString(), (Matcher)Is.is((Object)"test2"));
        muleEvent = (Event)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)muleEvent.getMessage().getPayload().getValue().toString(), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void failBetweenLogEntryWriteAndRealPoolThenRecover() throws Exception {
        this.inQueue.offer((Serializable)this.testEvent(), 0, 10L);
        this.persistentTransactionContext.poll((QueueStore)this.inQueue, 10L);
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer.recover();
        Event muleEvent = (Event)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)this.testEvent().getContext().getId(), (Matcher)CoreMatchers.equalTo((Object)muleEvent.getContext().getId()));
        muleEvent = (Event)this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    private QueueProvider createQueueProvider(final DefaultQueueStore queue) {
        return new QueueProvider(){

            public QueueStore getQueue(String queueName) {
                throw new NotImplementedException();
            }

            public RecoverableQueueStore getRecoveryQueue(String queueName) {
                return queue;
            }
        };
    }

    @Test
    public void offerAndFailThenRecover() throws Exception {
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(outQueue));
        this.persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)this.testEvent(), 10L);
        Assert.assertThat((Object)outQueue.poll(10L), (Matcher)IsNull.nullValue());
        this.txLog.close();
        this.txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(outQueue));
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    @Test
    public void offerAndFailBetweenRealOfferAndCommitThenRecover() throws Exception {
        this.txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext).failDuringLogCommit();
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        this.persistentTransactionContext = new PersistentQueueTransactionContext(this.txLog, this.createQueueProvider(outQueue));
        this.persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)this.testEvent(), 10L);
        try {
            this.persistentTransactionContext.doCommit();
            Assert.fail();
        }
        catch (ResourceManagerException resourceManagerException) {
            // empty catch block
        }
        this.txLog.close();
        this.txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.txLog, this.createQueueProvider(outQueue));
        this.queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }
}

