/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.context.DefaultMuleContextFactory;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.security.DefaultMuleSecurityManager;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueueManagerLifecycleOrderTestCase
extends AbstractMuleTestCase {
    private List<Object> startStopOrder = new ArrayList<Object>();
    private RecordingTQM rtqm = new RecordingTQM();
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private MuleContext muleContext;

    @Before
    public void before() throws InitialisationException, ConfigurationException {
        this.muleContext = new DefaultMuleContextFactory().createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new QueueManagerOnlyConfigurationBuilder()});
        this.testServicesConfigurationBuilder.configure(this.muleContext);
    }

    @After
    public void after() {
        this.muleContext.dispose();
    }

    @Test
    public void testStartupOrder() throws Exception {
        RecordingFlow fc = new RecordingFlow("dummy", this.muleContext);
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)fc);
        this.muleContext.start();
        this.muleContext.stop();
        Assert.assertEquals((long)4L, (long)this.startStopOrder.size());
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(0));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(1));
        Assert.assertSame((Object)((Object)fc), (Object)this.startStopOrder.get(2));
        Assert.assertSame((Object)this.rtqm, (Object)this.startStopOrder.get(3));
    }

    private class QueueManagerOnlyConfigurationBuilder
    extends DefaultsConfigurationBuilder {
        private QueueManagerOnlyConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
            muleContext.getRegistry().registerObject("_muleQueueManager", (Object)QueueManagerLifecycleOrderTestCase.this.rtqm);
            muleContext.getRegistry().registerObject("_muleSecurityManager", (Object)new DefaultMuleSecurityManager());
        }
    }

    private class RecordingFlow
    extends DefaultFlowBuilder.DefaultFlow {
        public RecordingFlow(String name, MuleContext muleContext) {
            super(name, muleContext);
        }

        public void doStart() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void doStop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }
    }

    private class RecordingTQM
    implements QueueManager {
        private RecordingTQM() {
        }

        public void start() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public void stop() throws MuleException {
            QueueManagerLifecycleOrderTestCase.this.startStopOrder.add(this);
        }

        public QueueSession getQueueSession() {
            throw new NotImplementedException();
        }

        public void setDefaultQueueConfiguration(QueueConfiguration config) {
            throw new NotImplementedException();
        }

        public void setQueueConfiguration(String queueName, QueueConfiguration config) {
            throw new NotImplementedException();
        }
    }
}

