/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue;

import java.io.Serializable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.util.queue.QueueStore;
import org.mule.runtime.core.util.queue.QueueTransactionContext;
import org.mule.runtime.core.util.queue.QueueTransactionContextFactory;
import org.mule.runtime.core.util.queue.QueueTypeTransactionContextAdapter;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class QueueTypeTransactionContextAdapterTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private QueueTransactionContextFactory<QueueTransactionContext> mockQueueTransactionContextFactory;
    @Mock
    private QueueStore mockQueueStore;
    @Mock
    private Serializable mockValue;

    @Test
    public void createPersistentContextWhenQueueIsPersistent() throws InterruptedException {
        QueueTypeTransactionContextAdapter queueTransactionContext = new QueueTypeTransactionContextAdapter(this.mockQueueTransactionContextFactory);
        Mockito.when((Object)this.mockQueueStore.isPersistent()).thenReturn((Object)true);
        queueTransactionContext.offer(this.mockQueueStore, this.mockValue, 10L);
        Mockito.verify((Object)this.mockQueueTransactionContextFactory.createPersistentTransactionContext());
    }

    @Test
    public void createTransientContextWhenQueueIsPersistent() throws InterruptedException {
        QueueTypeTransactionContextAdapter queueTransactionContext = new QueueTypeTransactionContextAdapter(this.mockQueueTransactionContextFactory);
        Mockito.when((Object)this.mockQueueStore.isPersistent()).thenReturn((Object)false);
        queueTransactionContext.offer(this.mockQueueStore, this.mockValue, 10L);
        Mockito.verify((Object)this.mockQueueTransactionContextFactory.createTransientTransactionContext());
    }
}

