/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.core.util.store.AbstractMonitoredObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MonitoredObjectStoreTestCase
extends AbstractMuleContextTestCase {
    private static final int EXPIRATION_INTERVAL = 500;

    @Test
    public void testShutdownWithHangingExpireThread() throws Exception {
        ExpiringStore store = this.createExpiringStore();
        Thread.sleep(1000L);
        store.dispose();
        Assert.assertTrue((boolean)store.expireStarted);
        Assert.assertFalse((boolean)store.expireFinished);
    }

    private ExpiringStore createExpiringStore() throws InitialisationException {
        ExpiringStore store = new ExpiringStore();
        store.setMuleContext(muleContext);
        store.setExpirationInterval(500);
        store.initialise();
        return store;
    }

    private static class ExpiringStore
    extends AbstractMonitoredObjectStore<String> {
        protected boolean expireStarted = false;
        protected boolean expireFinished = false;

        protected void expire() {
            try {
                this.expireStarted = true;
                Thread.sleep(5000L);
                this.expireFinished = true;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("expire was interrupted", e);
            }
        }

        public boolean contains(Serializable id) throws ObjectStoreNotAvailableException {
            return false;
        }

        public String remove(Serializable id) throws ObjectStoreException {
            return null;
        }

        public String retrieve(Serializable id) throws ObjectStoreException {
            return null;
        }

        public void store(Serializable id, String item) throws ObjectStoreException {
        }

        public void clear() {
        }

        public boolean isPersistent() {
            return false;
        }
    }
}

