/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.store.PartitionableObjectStore;
import org.mule.runtime.core.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.util.store.ObjectStorePartition;
import org.mule.runtime.core.util.store.PartitionedInMemoryObjectStore;
import org.mule.runtime.core.util.store.PartitionedPersistentObjectStore;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleObjectStoreManagerTestCase
extends AbstractMuleTestCase {
    public static final String TEST_PARTITION_NAME = "partition";
    public static final int POLLING_TIMEOUT = 1000;
    public static final int POLLING_DELAY = 60;
    public static final String TEST_KEY = "Some Key";
    public static final String TEST_VALUE = "Some Value";
    private SimpleUnitTestSupportSchedulerService schedulerService;
    private MuleContext muleContext;
    private MuleObjectStoreManager storeManager;
    @Rule
    public TemporaryFolder tempWorkDir = new TemporaryFolder();

    @Before
    public void setup() {
        this.schedulerService = new SimpleUnitTestSupportSchedulerService();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.muleContext.getSchedulerService()).thenReturn((Object)this.schedulerService);
        Mockito.when((Object)this.muleContext.getSchedulerBaseConfig()).thenReturn((Object)SchedulerConfig.config().withPrefix(MuleObjectStoreManagerTestCase.class.getName() + "#" + this.name.getMethodName()));
        this.storeManager = new MuleObjectStoreManager();
        this.storeManager.setMuleContext(this.muleContext);
    }

    @After
    public void after() throws MuleException {
        this.schedulerService.stop();
    }

    @Test
    public void disposeDisposableStore() throws ObjectStoreException {
        ObjectStore store = (ObjectStore)Mockito.mock(ObjectStore.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}));
        this.storeManager.disposeStore(store);
        ((ObjectStore)Mockito.verify((Object)store)).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }

    @Test
    public void disposePartitionableStore() throws ObjectStoreException {
        ObjectStorePartition store = (ObjectStorePartition)Mockito.mock(ObjectStorePartition.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}).defaultAnswer(Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)store.getPartitionName()).thenReturn((Object)TEST_PARTITION_NAME);
        this.storeManager.disposeStore((ObjectStore)store);
        ((PartitionableObjectStore)Mockito.verify((Object)store.getBaseStore())).disposePartition(TEST_PARTITION_NAME);
        ((ObjectStorePartition)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }

    @Test
    public void ensureTransientPartitionIsCleared() throws ObjectStoreException, InitialisationException {
        this.ensurePartitionIsCleared(false);
    }

    @Test
    public void ensurePersistentPartitionIsCleared() throws ObjectStoreException, InitialisationException {
        this.ensurePartitionIsCleared(true);
    }

    private void ensurePartitionIsCleared(boolean isPersistent) throws ObjectStoreException, InitialisationException {
        try {
            ObjectStorePartition<Serializable> store = this.createStorePartition(TEST_PARTITION_NAME, isPersistent);
            store.getBaseStore().store((Serializable)((Object)TEST_KEY), (Serializable)((Object)TEST_VALUE), TEST_PARTITION_NAME);
            Assert.assertThat((Object)store.allKeys().size(), (Matcher)Is.is((Object)1));
            this.storeManager.disposeStore(store);
            Assert.assertThat((Object)store.allKeys().size(), (Matcher)Is.is((Object)0));
        }
        finally {
            this.storeManager.dispose();
        }
    }

    @Test
    public void removeStoreAndMonitorOnTransientPartition() throws ObjectStoreException, InitialisationException {
        this.removeStoreAndMonitor(false);
    }

    @Test
    public void removeStoreAndMonitorOnPersistentPartition() throws ObjectStoreException, InitialisationException {
        this.removeStoreAndMonitor(true);
    }

    private void removeStoreAndMonitor(boolean isPersistent) throws ObjectStoreException, InitialisationException {
        try {
            ObjectStorePartition<Serializable> store = this.createStorePartition(TEST_PARTITION_NAME, isPersistent);
            this.assertMonitorsCount(1);
            this.storeManager.disposeStore(store);
            Assert.assertThat(this.storeManager.stores.keySet(), (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Object)TEST_PARTITION_NAME)));
            this.assertMonitorsCount(0);
        }
        finally {
            this.storeManager.dispose();
        }
    }

    private void assertMonitorsCount(final int expectedValue) {
        new PollingProber(1000L, 60L).check(new Probe(){

            public boolean isSatisfied() {
                return this.assertMonitors(expectedValue);
            }

            private boolean assertMonitors(int expectedValue2) {
                return MuleObjectStoreManagerTestCase.this.storeManager.getMonitorsCount() == expectedValue2;
            }

            public String describeFailure() {
                return "Unexpected count of active monitors.";
            }
        });
    }

    private ObjectStorePartition<Serializable> createStorePartition(String partitionName, boolean isPersistent) throws InitialisationException {
        SerializationTestUtils.addJavaSerializerToMockMuleContext((MuleContext)this.muleContext);
        this.createRegistryAndBaseStore(this.muleContext, isPersistent);
        this.storeManager.setMuleContext(this.muleContext);
        this.storeManager.initialise();
        ObjectStorePartition store = (ObjectStorePartition)this.storeManager.getObjectStore(partitionName, isPersistent, 0, 10000L, 50L);
        Assert.assertThat(this.storeManager.stores.keySet(), (Matcher)IsCollectionContaining.hasItem((Object)partitionName));
        return store;
    }

    private void createRegistryAndBaseStore(MuleContext muleContext, boolean isPersistent) {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        if (isPersistent) {
            PartitionableObjectStore<?> store = this.createPersistentPartitionableObjectStore(muleContext);
            Mockito.when((Object)muleRegistry.lookupObject("_defaultPersistentObjectStore")).thenReturn(store);
        } else {
            PartitionableObjectStore<?> store = this.createTransientPartitionableObjectStore();
            Mockito.when((Object)muleRegistry.lookupObject("_defaultInMemoryObjectStore")).thenReturn(store);
        }
        Mockito.when((Object)muleContext.getRegistry()).thenReturn((Object)muleRegistry);
    }

    private PartitionableObjectStore<?> createTransientPartitionableObjectStore() {
        return new PartitionedInMemoryObjectStore();
    }

    private PartitionableObjectStore<?> createPersistentPartitionableObjectStore(MuleContext muleContext) {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getWorkingDirectory()).thenReturn((Object)this.tempWorkDir.getRoot().getAbsolutePath());
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        return new PartitionedPersistentObjectStore(muleContext);
    }

    @Test
    public void dontFailIfUnsupported() throws ObjectStoreException {
        ObjectStore store = (ObjectStore)Mockito.mock(ObjectStore.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}));
        ((ObjectStore)Mockito.doThrow(UnsupportedOperationException.class).when((Object)store)).clear();
        this.storeManager.disposeStore(store);
        ((ObjectStore)Mockito.verify((Object)store)).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }
}

