/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.File;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.util.store.PersistentObjectStorePartition;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PersistentObjectStorePartitionTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder objectStoreFolder = new TemporaryFolder();
    @Mock
    private MuleContext muleContext;
    @Mock
    private MuleConfiguration muleConfiguration;
    private File workingDirectory;
    private PersistentObjectStorePartition partition;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getExecutionClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        this.workingDirectory = this.objectStoreFolder.getRoot().getParentFile();
        Mockito.when((Object)this.muleConfiguration.getWorkingDirectory()).thenReturn((Object)this.workingDirectory.getPath());
        SerializationTestUtils.addJavaSerializerToMockMuleContext((MuleContext)this.muleContext);
        this.partition = new PersistentObjectStorePartition(this.muleContext, "test", this.objectStoreFolder.getRoot());
        this.partition.open();
    }

    @Test
    public void indicatesUnexistentKeyOnRetrieveError() throws ObjectStoreException {
        String nonExistentKey = "nonExistentKey";
        try {
            this.partition.retrieve((Serializable)((Object)"nonExistentKey"));
            Assert.fail((String)"Supposed to thrown an exception as key is not valid");
        }
        catch (ObjectDoesNotExistException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("nonExistentKey"));
        }
    }

    @Test
    public void skipAndMoveCorruptedOrUnreadableFiles() {
        String KEY = "key";
        String VALUE = "value";
        try {
            File.createTempFile("temp", ".obj", this.objectStoreFolder.getRoot());
            File corruptedFolder = FileUtils.openDirectory((String)(this.workingDirectory.getAbsolutePath() + File.separator + "corrupted-files"));
            int corruptedBefore = corruptedFolder.list().length;
            this.partition.store((Serializable)((Object)"key"), (Serializable)((Object)"value"));
            Assert.assertEquals((long)2L, (long)this.objectStoreFolder.getRoot().listFiles().length);
            Assert.assertEquals((long)(corruptedBefore + 1), (long)corruptedFolder.list().length);
        }
        catch (Exception e) {
            Assert.fail((String)"Supposed to have skipped corrupted or unreadable files");
        }
    }

    @Test
    public void clear() throws Exception {
        String KEY = "key";
        String VALUE = "value";
        this.partition.store((Serializable)((Object)"key"), (Serializable)((Object)"value"));
        Assert.assertTrue((boolean)this.partition.contains((Serializable)((Object)"key")));
        Assert.assertEquals((Object)"value", (Object)this.partition.retrieve((Serializable)((Object)"key")));
        this.partition.clear();
        junit.framework.Assert.assertFalse((boolean)this.partition.contains((Serializable)((Object)"key")));
    }

    @Test
    public void clearBeforeLoading() throws Exception {
        this.partition.clear();
        Assert.assertEquals((long)0L, (long)this.partition.allKeys().size());
    }
}

