/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultMessageContextTestCase
extends AbstractMuleTestCase {
    private static final String GENERATED_CORRELATION_ID = "generatedCorrelationIdValue";
    private static final String CUSTOM_CORRELATION_ID = "customCorrelationIdValue";
    private static final String SERVER_ID = "serverId";
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private FlowConstruct flow;
    private EventContext executionContext;
    private EventContext executionContextWithCorrelation;

    @Before
    public void before() {
        Mockito.when((Object)this.flow.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.flow.getUniqueIdString()).thenReturn((Object)GENERATED_CORRELATION_ID);
        Mockito.when((Object)this.flow.getServerId()).thenReturn((Object)SERVER_ID);
        this.executionContext = EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        this.executionContextWithCorrelation = EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)CUSTOM_CORRELATION_ID);
    }

    @Test
    public void noCorrelationIdInContext() {
        Message message = Message.of((Object)"test");
        InternalEvent event = InternalEvent.builder((EventContext)this.executionContext).message(message).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)GENERATED_CORRELATION_ID));
    }

    @Test
    public void correlationIdInContext() {
        Message message = Message.of((Object)"test");
        InternalEvent event = InternalEvent.builder((EventContext)this.executionContextWithCorrelation).message(message).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }

    @Test
    public void overrideCorrelationIdInContext() {
        Message message = Message.of((Object)"test");
        InternalEvent event = InternalEvent.builder((EventContext)this.executionContextWithCorrelation).message(message).groupCorrelation(Optional.empty()).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }

    @Test
    public void overrideCorrelationIdInContextSequence() {
        Message message = Message.of((Object)"test");
        InternalEvent event = InternalEvent.builder((EventContext)this.executionContextWithCorrelation).message(message).correlationId(CUSTOM_CORRELATION_ID).groupCorrelation(Optional.of(GroupCorrelation.of((int)6))).build();
        Assert.assertThat((Object)event.getCorrelationId(), (Matcher)CoreMatchers.is((Object)CUSTOM_CORRELATION_ID));
    }
}

