/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.LocatedMuleException;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class LocatedMuleExceptionTestCase
extends AbstractMuleContextTestCase {
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private ComponentLocation mockComponentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);

    @Test
    public void namedComponent() {
        NamedObject named = (NamedObject)Mockito.mock(NamedObject.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)named.getName()).thenReturn((Object)"mockComponent");
        LocatedMuleException lme = new LocatedMuleException((Object)named);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/mockComponent @ app:internal:-1"));
    }

    @Test
    public void annotatedComponent() {
        Component annotated = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)annotated.getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)annotated.toString()).thenReturn((Object)"Mock@1");
        this.configureProcessorLocation(annotated);
        LocatedMuleException lme = new LocatedMuleException((Object)annotated);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ app:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void namedAnnotatedComponent() {
        Component namedAnnotated = (Component)Mockito.mock(Component.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{NamedObject.class}));
        Mockito.when((Object)((NamedObject)namedAnnotated).getName()).thenReturn((Object)"mockComponent");
        Mockito.when((Object)namedAnnotated.getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)namedAnnotated.toString()).thenReturn((Object)"Mock@1");
        this.configureProcessorLocation(namedAnnotated);
        LocatedMuleException lme = new LocatedMuleException((Object)namedAnnotated);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/mockComponent @ app:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void rawComponent() {
        Object raw = Mockito.mock(Object.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)raw.toString()).thenReturn((Object)"Mock@1");
        LocatedMuleException lme = new LocatedMuleException(raw);
        Assert.assertThat((Object)lme.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ app:internal:-1"));
    }

    private void configureProcessorLocation(Component component) {
        Mockito.when((Object)component.getLocation()).thenReturn((Object)this.mockComponentLocation);
        Mockito.when((Object)this.mockComponentLocation.getFileName()).thenReturn(Optional.of("muleApp.xml"));
        Mockito.when((Object)this.mockComponentLocation.getLineInFile()).thenReturn(Optional.of(10));
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"Mock@1");
    }
}

