/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.io.ByteArrayInputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.builder.MockConverterBuilder;
import org.mule.runtime.core.internal.transformer.builder.MockTransformerBuilder;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransformationServiceTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private DataTypeConversionResolver conversionResolver = (DataTypeConversionResolver)Mockito.mock(DataTypeConversionResolver.class);
    private ExtendedTransformationService transformationService;
    private static final DataType dataTypeB = DataType.fromType(B.class);
    private static final DataType dataTypeC = DataType.fromType(C.class);
    private static final DataType dataTypeD = DataType.fromType(D.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getDataTypeConverterResolver()).thenReturn((Object)this.conversionResolver);
        this.transformationService = new ExtendedTransformationService(this.muleContext);
    }

    @Test
    public void failsOnConverterWhenSourceAndReturnTypeDoesNotMatchAndThereIsNoImplicitConversion() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
    }

    @Test
    public void failsOnConverterWhenSourceAndReturnTypeDoesNotMatchAndThereIsNoImplicitConversion2() throws MuleException {
        ByteArrayInputStream payload = new ByteArrayInputStream("test".getBytes());
        DataType originalSourceType = DataType.fromType(payload.getClass());
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(originalSourceType)).to(dataTypeC)).build();
        A transformedPayload = new A();
        Mockito.when((Object)converter1.transform(org.mockito.Matchers.any())).thenReturn((Object)transformedPayload);
        Message message = Message.of((Object)payload);
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (MessageTransformerException expected) {
            Assert.assertThat((Object)expected.getErrorMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)transformedPayload));
        }
    }

    @Test
    public void appliesImplicitConversionOnConverterWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)org.mockito.Matchers.any(DataType.class), org.mockito.Matchers.anyList())).thenReturn((Object)converter2);
        Message message = Message.of((Object)new B());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void appliesConverter() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Message message = Message.of((Object)new B());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof C));
        this.verifyTransformerExecuted((Transformer)converter1);
    }

    @Test
    public void skipsConverterThatDoesNotMatchWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Message message = Message.of((Object)new C());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof C));
        this.verifyTransformerNotExecuted((Transformer)converter1);
    }

    @Test
    public void failsTransformationUsingConverterWhenSourceAndReturnTypeDoesNotMatch2() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void appliesBothConverters() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        Message message = Message.of((Object)new B());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void skipsFirstConverterAppliesSecond() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        Message message = Message.of((Object)new C());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void skipBothConvertersButPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new D());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringNonMatchingConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void appliesTransformerSkipsConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new B());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, converter2});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringMatchingConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new C());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringMatchingConverterWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new D());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void skipsConverterFailsOnTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void appliesConverterFailsOnTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new B());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void skipsConverterAppliesTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        Message message = Message.of((Object)new C());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, transformer2});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerExecuted(transformer2);
    }

    @Test
    public void skipsConverterFailsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new D());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void appliesFirstTransformerFailsOnSecondTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new B());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new C());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        Message message = Message.of((Object)new D());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnTransformerWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Message message = Message.of((Object)new A());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
    }

    @Test
    public void appliesTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Message message = Message.of((Object)new B());
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1});
        Assert.assertTrue((boolean)(message.getPayload().getValue() instanceof C));
        this.verifyTransformerExecuted(transformer1);
    }

    @Test
    public void failsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Message message = Message.of((Object)new C());
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
    }

    @Test
    public void failsWhenNoImplicitConversionAvailable() throws MuleException {
        Transformer transformer = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(DataType.BYTE_ARRAY)).to(DataType.STRING)).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)org.mockito.Matchers.any(DataType.class), org.mockito.Matchers.anyList())).thenReturn(null);
        Message message = Message.of((Object)"TEST");
        try {
            this.transformationService.applyTransformers(message, null, new Transformer[]{transformer});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer);
    }

    @Test
    public void appliesImplicitConversionWhenAvailable() throws MuleException {
        Transformer transformer = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(DataType.BYTE_ARRAY)).to(DataType.STRING)).returning("bar")).build();
        Converter converter = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataType.STRING)).to(DataType.BYTE_ARRAY)).returning("bar".getBytes())).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)org.mockito.Matchers.any(DataType.class), org.mockito.Matchers.anyList())).thenReturn((Object)converter);
        Message message = Message.of((Object)"TEST");
        message = this.transformationService.applyTransformers(message, null, new Transformer[]{transformer});
        Assert.assertEquals((Object)"bar", (Object)message.getPayload().getValue());
        this.verifyTransformerExecuted(transformer);
        this.verifyTransformerExecuted((Transformer)converter);
    }

    private void verifyTransformerNotExecuted(Transformer converter1) throws TransformerException {
        ((Transformer)Mockito.verify((Object)converter1, (VerificationMode)Mockito.times((int)0))).transform(org.mockito.Matchers.any(Object.class));
    }

    private void verifyTransformerExecuted(Transformer converter1) throws TransformerException {
        ((Transformer)Mockito.verify((Object)converter1, (VerificationMode)Mockito.times((int)1))).transform(org.mockito.Matchers.any(Object.class));
    }

    private class D {
        private D() {
        }
    }

    private class C {
        private C() {
        }
    }

    private class B {
        private B() {
        }
    }

    private class A {
        private A() {
        }
    }
}

