/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.internal.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.util.MuleContextUtils;

public class DefaultMuleContextFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private static String TEST_STRING_KEY = "test";
    private static String TEST_STRING_VALUE = "test_value";
    private static String TEST_STRING_KEY2 = "test2";
    private static String TEST_STRING_VALUE2 = "test_value2";
    private static String TEST_OBJECT_NAME = "testObject";
    private MuleContext context;
    private SimpleConfigurationBuilder testConfigBuilder;
    private SimpleConfigurationBuilder testConfigBuilder2;

    @Before
    public void before() {
        HashMap<String, String> objects = new HashMap<String, String>();
        objects.put(TEST_STRING_KEY, TEST_STRING_VALUE);
        objects.put(TEST_OBJECT_NAME, (String)new Banana());
        this.testConfigBuilder = new SimpleConfigurationBuilder(objects);
        this.testConfigBuilder2 = new SimpleConfigurationBuilder(Collections.singletonMap(TEST_STRING_KEY2, TEST_STRING_VALUE2));
    }

    @After
    public void disposeContext() {
        if (this.context != null && !this.context.isDisposed()) {
            this.context.dispose();
        }
    }

    @Test
    public void testCreateMuleContext() throws InitialisationException, ConfigurationException {
        this.context = this.muleContextFactory.createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new DefaultsConfigurationBuilder()});
        this.assertMuleContextConfiguration(this.context);
        this.assertDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilder() throws InitialisationException, ConfigurationException {
        this.context = this.muleContextFactory.createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, this.testConfigBuilder});
        this.assertMuleContextConfiguration(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextListMuleContextBuilder() throws InitialisationException, ConfigurationException {
        ArrayList<Object> configBuilders = new ArrayList<Object>();
        configBuilders.add(this.testServicesConfigurationBuilder);
        configBuilders.add(this.testConfigBuilder);
        configBuilders.add(this.testConfigBuilder2);
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(configBuilders, (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        this.assertConfigurationBuilder2Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(this.testServicesConfigurationBuilder, new SimpleConfigurationBuilder(null)), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(this.testServicesConfigurationBuilder, this.testConfigBuilder2), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(this.context);
        this.assertConfigurationBuilder2Objects(this.context);
        this.assertNoDefaults(this.context);
    }

    @Test
    public void testCreateMuleContextString() throws InitialisationException, ConfigurationException {
        this.context = null;
        try {
            this.context = this.muleContextFactory.createMuleContext("log4j2-test.xml");
        }
        catch (ConfigurationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j2-test.xml'}]\" found.  Check you have configuration module on your classpath and are using correct file extension."));
        }
        Assert.assertNull((Object)this.context);
    }

    @Test
    public void testCreateMuleContextStringProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey1", "testValue1");
        properties.put("testKey2", "testValue2");
        this.context = null;
        try {
            this.context = this.muleContextFactory.createMuleContext("log4j2-test.xml", (Map)properties);
        }
        catch (ConfigurationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j2-test.xml'}]\" found.  Check you have configuration module on your classpath and are using correct file extension."));
        }
        Assert.assertNull((Object)this.context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey3", "testValue3");
        properties.put("testKey4", "testValue4");
        this.context = this.muleContextFactory.createMuleContext(Arrays.asList(this.testServicesConfigurationBuilder, this.testConfigBuilder), (Map)properties);
        this.assertMuleContextConfiguration(this.context);
        this.assertConfigurationBuilder1Objects(this.context);
        Assert.assertEquals((Object)"testValue3", (Object)((MuleContextWithRegistries)this.context).getRegistry().lookupObject("testKey3"));
        Assert.assertEquals((Object)"testValue4", (Object)((MuleContextWithRegistries)this.context).getRegistry().lookupObject("testKey4"));
        this.assertNoDefaults(this.context);
    }

    @Test
    public void notifiesMuleContextEvents() throws InitialisationException, ConfigurationException {
        MuleContextListener listener = (MuleContextListener)Mockito.mock(MuleContextListener.class);
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)Mockito.mock(ConfigurationBuilder.class);
        this.context = MuleContextUtils.mockMuleContext();
        this.context = MuleContextUtils.mockMuleContext();
        ((MuleContext)Mockito.doAnswer(invocation -> {
            listener.onInitialization(this.context, null);
            return null;
        }).when((Object)this.context)).initialise();
        MuleContextBuilder contextBuilder = (MuleContextBuilder)Mockito.mock(MuleContextBuilder.class);
        Mockito.when((Object)contextBuilder.buildMuleContext()).thenReturn((Object)this.context);
        this.muleContextFactory.addListener(listener);
        this.muleContextFactory.createMuleContext(configurationBuilder, contextBuilder);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{listener});
        ((MuleContextListener)inOrder.verify((Object)listener, Mockito.times((int)1))).onCreation(this.context);
        ((MuleContextListener)inOrder.verify((Object)listener, Mockito.times((int)1))).onInitialization((MuleContext)Matchers.eq((Object)this.context), (Registry)Matchers.any(Registry.class));
    }

    private void assertDefaults(MuleContext context) {
        junit.framework.Assert.assertNotNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_muleQueueManager"));
        junit.framework.Assert.assertNotNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_muleSecurityManager"));
        junit.framework.Assert.assertNotNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_defaultInMemoryObjectStore"));
    }

    private void assertNoDefaults(MuleContext context) {
        Assert.assertNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_muleQueueManager"));
        Assert.assertNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_muleSecurityManager"));
        Assert.assertNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        Assert.assertNull((Object)((MuleContextWithRegistries)context).getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void assertMuleContextConfiguration(MuleContext context) {
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.instanceOf(DefaultMuleContext.class));
        Assert.assertTrue((boolean)context.isInitialised());
        MatcherAssert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.instanceOf(DefaultMuleConfiguration.class));
        MatcherAssert.assertThat((Object)context.getLifecycleManager(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context.getNotificationManager(), (Matcher)CoreMatchers.notNullValue());
    }

    private void assertCustomMuleContext(MuleContext context) {
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.instanceOf(TestMuleContext.class));
        Assert.assertTrue((boolean)context.isInitialised());
        MatcherAssert.assertThat((Object)context.getConfiguration(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context.getLifecycleManager(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context.getNotificationManager(), (Matcher)CoreMatchers.notNullValue());
    }

    private void assertConfigurationBuilder1Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE, (Object)((MuleContextWithRegistries)context).getRegistry().lookupObject(TEST_STRING_KEY));
        Object obj = ((MuleContextWithRegistries)context).getRegistry().lookupObject(TEST_OBJECT_NAME);
        junit.framework.Assert.assertNotNull((Object)obj);
        Assert.assertEquals(Banana.class, obj.getClass());
    }

    private void assertConfigurationBuilder2Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE2, (Object)((MuleContextWithRegistries)context).getRegistry().lookupObject(TEST_STRING_KEY2));
    }

    static class TestMuleConfiguration
    extends DefaultMuleConfiguration {
        TestMuleConfiguration() {
        }
    }

    static class TestMuleContext
    extends DefaultMuleContext {
    }

    static class TestMuleContextBuilder
    extends DefaultMuleContextBuilder {
        public TestMuleContextBuilder() {
            super(ArtifactType.APP);
        }

        protected DefaultMuleContext createDefaultMuleContext() {
            return new TestMuleContext();
        }
    }
}

