/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.Event1;
import org.mule.runtime.core.api.context.notification.Event2;
import org.mule.runtime.core.api.context.notification.Event3;
import org.mule.runtime.core.api.context.notification.Listener1;
import org.mule.runtime.core.api.context.notification.Listener2;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.context.notification.SubEvent1;
import org.mule.runtime.core.api.context.notification.SubEvent2;
import org.mule.runtime.core.api.context.notification.SubSubEvent1;
import org.mule.runtime.core.internal.context.notification.Policy;
import org.mule.runtime.core.privileged.context.notification.OptimisedNotificationHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class NotificationManagerTestCase
extends AbstractMuleTestCase {
    protected Listener1 listener1;
    protected Listener2 listener2;
    protected ServerNotificationManager manager;

    @Before
    public void setUpListeners() {
        this.listener1 = new Listener1();
        this.listener2 = new Listener2();
        this.manager = new ServerNotificationManager();
    }

    protected void registerDefaultEvents() throws ClassNotFoundException {
        this.manager.addInterfaceToType(Listener1.class, SubEvent1.class);
        this.manager.addInterfaceToType(Listener2.class, Event2.class);
    }

    @Test
    public void testNoListenersMeansNoEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.assertNoEventsEnabled();
    }

    protected void assertNoEventsEnabled() {
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(Event1.class));
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(Event2.class));
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        Assert.assertFalse((boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    protected void registerDefaultListeners() {
        this.manager.addListenerSubscription((NotificationListener)this.listener1, notification -> "id1".equals(notification.getResourceIdentifier()));
        this.manager.addListener((NotificationListener)this.listener2);
    }

    @Test
    public void testAssociationOfInterfacesAndEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
    }

    protected void assertStandardEventsEnabled() {
        Assert.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        Assert.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        Assert.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        Assert.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(Event2.class));
        Assert.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        Assert.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    @Test
    public void testDynamicResponseToDisablingEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
        this.manager.disableType(Event2.class);
        Assert.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        Assert.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        Assert.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(Event2.class));
        Assert.assertFalse((String)"no listener", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        Assert.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
        this.manager.addInterfaceToType(Listener2.class, SubEvent2.class);
        Assert.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        Assert.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        Assert.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(Event2.class));
        Assert.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        Assert.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    @Test
    public void testDynamicResponseToDisablingInterfaces() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
        this.manager.disableInterface(Listener1.class);
        Assert.assertFalse((String)"via subclass, but no listener", (boolean)this.manager.isNotificationEnabled(Event1.class));
        Assert.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        Assert.assertFalse((String)"via superclass, but no listener", (boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        Assert.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(Event2.class));
        Assert.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        Assert.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    @Test
    public void testPolicyCaching() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        Policy policy = this.manager.getPolicy();
        this.assertStandardEventsEnabled();
        Assert.assertSame((Object)policy, (Object)this.manager.getPolicy());
        this.manager.disableType(Event2.class);
        Assert.assertNotSame((Object)policy, (Object)this.manager.getPolicy());
    }

    @Test
    public void testDynamicManagerDecisions() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.manager.setNotificationDynamic(true);
        OptimisedNotificationHandler decision = new OptimisedNotificationHandler((ServerNotificationHandler)this.manager, Event2.class);
        Assert.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
        this.manager.disableType(Event2.class);
        Assert.assertFalse((boolean)decision.isNotificationEnabled(Event2.class));
    }

    @Test
    public void testNonDynamicManagerDecisions() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        OptimisedNotificationHandler decision = new OptimisedNotificationHandler((ServerNotificationHandler)this.manager, Event2.class);
        Assert.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
        this.manager.disableType(Event2.class);
        Assert.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
    }

    @Test
    public void testNotification() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertNoListenersNotified();
        this.manager.notifyListeners((Notification)new Event1(), (listener, nfn) -> listener.onNotification(nfn));
        this.assertNoListenersNotified();
        this.manager.notifyListeners((Notification)new SubEvent1(), (listener, nfn) -> listener.onNotification(nfn));
        this.assertNoListenersNotified();
        this.manager.notifyListeners((Notification)new Event1("id1"), (listener, nfn) -> listener.onNotification(nfn));
        this.assertNoListenersNotified();
        this.manager.notifyListeners((Notification)new SubSubEvent1("id1"), (listener, nfn) -> listener.onNotification(nfn));
        Assert.assertTrue((boolean)this.listener1.isNotified());
        Assert.assertFalse((boolean)this.listener2.isNotified());
        this.manager.notifyListeners((Notification)new Event2(), (listener, nfn) -> listener.onNotification(nfn));
        Assert.assertTrue((boolean)this.listener1.isNotified());
        Assert.assertTrue((boolean)this.listener2.isNotified());
    }

    protected void assertNoListenersNotified() {
        Assert.assertFalse((boolean)this.listener1.isNotified());
        Assert.assertFalse((boolean)this.listener2.isNotified());
    }
}

