/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.EventObject;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.notification.CustomNotification;
import org.mule.runtime.api.notification.CustomNotificationListener;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.DummyListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ServerNotificationsTestCase
extends AbstractMuleContextTestCase
implements MuleContextNotificationListener {
    private final AtomicBoolean managerStopped = new AtomicBoolean(false);
    private final AtomicInteger managerStoppedEvents = new AtomicInteger(0);
    private final AtomicInteger customNotificationCount = new AtomicInteger(0);

    public ServerNotificationsTestCase() {
        this.setStartContext(true);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.managerStopped.set(true);
        this.managerStoppedEvents.set(0);
    }

    @Test
    public void testStandardNotifications() throws Exception {
        this.getNotificationListenerRegistry().registerListener((NotificationListener)this);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
    }

    @Test
    public void testMultipleRegistrations() throws Exception {
        this.getNotificationListenerRegistry().registerListener((NotificationListener)this);
        this.getNotificationListenerRegistry().registerListener((NotificationListener)this);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
        Assert.assertEquals((long)1L, (long)this.managerStoppedEvents.get());
    }

    @Test
    public void testUnregistering() throws Exception {
        this.getNotificationListenerRegistry().registerListener((NotificationListener)this);
        this.getNotificationListenerRegistry().unregisterListener((NotificationListener)this);
        muleContext.stop();
        Assert.assertFalse((boolean)this.managerStopped.get());
    }

    @Test
    public void testMismatchingUnregistrations() throws Exception {
        this.getNotificationListenerRegistry().registerListener((NotificationListener)this);
        DummyListener dummy = new DummyListener();
        this.getNotificationListenerRegistry().registerListener((NotificationListener)dummy);
        this.getNotificationListenerRegistry().registerListener((NotificationListener)dummy);
        this.getNotificationListenerRegistry().unregisterListener((NotificationListener)dummy);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
        Assert.assertEquals((long)1L, (long)this.managerStoppedEvents.get());
    }

    @Test
    public void testCustomNotifications() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.getNotificationListenerRegistry().registerListener((NotificationListener)((DummyNotificationListener)notification -> {
            if (new IntegerAction(-999999).equals((Object)notification.getAction())) {
                this.customNotificationCount.incrementAndGet();
                Assert.assertEquals((Object)"hello", (Object)((EventObject)notification).getSource());
                latch.countDown();
            }
        }));
        this.getNotificationDispatcher().dispatch((Notification)new DummyNotification("hello", -999999));
        this.getNotificationDispatcher().dispatch((Notification)new DummyNotification("hello", -999999));
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)this.customNotificationCount.get());
    }

    @Test
    public void testAsyncNotificationRejectedExecution() {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        SchedulerService schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        Mockito.when((Object)muleContext.getSchedulerService()).thenReturn((Object)schedulerService);
        Mockito.when((Object)schedulerService.cpuLightScheduler()).thenReturn((Object)scheduler);
        Mockito.when((Object)scheduler.submit((Callable)Matchers.any(Callable.class))).thenThrow(new Throwable[]{new RejectedExecutionException()});
        Notification notification = (Notification)Mockito.mock(CustomNotification.class);
        Mockito.when((Object)notification.isSynchronous()).thenReturn((Object)false);
        NotificationListener notificationListener = (NotificationListener)Mockito.mock(CustomNotificationListener.class);
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.setMuleContext(muleContext);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        manager.addListener(notificationListener);
        manager.fireNotification(notification);
        ((NotificationListener)Mockito.verify((Object)notificationListener, (VerificationMode)Mockito.never())).onNotification(notification);
    }

    @Test
    public void testSyncNotificationException() {
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.setMuleContext(muleContext);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        Notification notification = (Notification)Mockito.mock(CustomNotification.class);
        Mockito.when((Object)notification.isSynchronous()).thenReturn((Object)true);
        NotificationListener notificationListener = (NotificationListener)Mockito.mock(CustomNotificationListener.class);
        ((NotificationListener)Mockito.doThrow((Throwable)new IllegalArgumentException()).when((Object)notificationListener)).onNotification((Notification)Matchers.any(CustomNotification.class));
        manager.addListener(notificationListener);
        manager.fireNotification(notification);
        ((NotificationListener)Mockito.verify((Object)notificationListener, (VerificationMode)Mockito.times((int)1))).onNotification(notification);
    }

    @Test
    public void testSyncNotificationError() {
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.setMuleContext(muleContext);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        Notification notification = (Notification)Mockito.mock(CustomNotification.class);
        Mockito.when((Object)notification.isSynchronous()).thenReturn((Object)true);
        NotificationListener notificationListener = (NotificationListener)Mockito.mock(CustomNotificationListener.class);
        ((NotificationListener)Mockito.doThrow((Throwable)new LinkageError()).when((Object)notificationListener)).onNotification((Notification)Matchers.any(CustomNotification.class));
        manager.addListener(notificationListener);
        manager.fireNotification(notification);
        ((NotificationListener)Mockito.verify((Object)notificationListener, (VerificationMode)Mockito.times((int)1))).onNotification(notification);
    }

    private NotificationListenerRegistry getNotificationListenerRegistry() throws RegistrationException {
        return (NotificationListenerRegistry)this.getResgistry().lookupObject(NotificationListenerRegistry.class);
    }

    private NotificationDispatcher getNotificationDispatcher() throws RegistrationException {
        return (NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
    }

    private MuleRegistry getResgistry() {
        return ((MuleContextWithRegistries)muleContext).getRegistry();
    }

    public boolean isBlocking() {
        return false;
    }

    public void onNotification(Notification notification) {
        if (new IntegerAction(106).equals((Object)notification.getAction())) {
            this.managerStopped.set(true);
            this.managerStoppedEvents.incrementAndGet();
        }
    }

    public class DummyNotification
    extends CustomNotification {
        private static final long serialVersionUID = -1117307108932589331L;
        public static final int EVENT_RECEIVED = -999999;

        public DummyNotification(String message, int action) {
            super((Object)message, action);
            this.resourceIdentifier = message;
        }
    }

    public static interface DummyNotificationListener
    extends CustomNotificationListener {
    }
}

