/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.event;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.DefaultMuleAuthentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.security.DefaultSecurityContextFactory;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.privileged.transformer.simple.SerializableToByteArray;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MuleEventTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @After
    public void teardown() {
        DefaultMuleContext.currentMuleContext.set(null);
    }

    @Test
    public void serialization() throws Exception {
        Transformer transformer = this.createSerializableToByteArrayTransformer();
        transformer.setMuleContext(muleContext);
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)this.testEvent());
        Assert.assertNotNull((Object)serialized);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        PrivilegedEvent deserialized = (PrivilegedEvent)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getSession());
    }

    private Transformer createSerializableToByteArrayTransformer() {
        SerializableToByteArray transformer = new SerializableToByteArray();
        transformer.setMuleContext(muleContext);
        return transformer;
    }

    @Test
    public void testEventSerializationRestart() throws Exception {
        CoreEvent event = this.createEventToSerialize();
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        muleContext.dispose();
        muleContext = this.createMuleContext();
        muleContext.start();
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        this.createAndRegisterTransformersEndpointBuilderService();
        PrivilegedEvent deserialized = (PrivilegedEvent)trans.transform((Object)serialized);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertNotNull((Object)deserialized.getSession());
    }

    private CoreEvent createEventToSerialize() throws Exception {
        this.createAndRegisterTransformersEndpointBuilderService();
        return this.testEvent();
    }

    @Test
    public void testMuleEventSerializationWithRawPayload() throws Exception {
        StringBuilder payload = new StringBuilder();
        for (int i = 0; i < 108; ++i) {
            payload.append("1234567890");
        }
        PrivilegedEvent testEvent = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)new ByteArrayInputStream(payload.toString().getBytes()))).build();
        DefaultMuleContext.currentMuleContext.set(muleContext);
        byte[] serializedEvent = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)testEvent);
        testEvent = (PrivilegedEvent)muleContext.getObjectSerializer().getExternalProtocol().deserialize(serializedEvent);
        Assert.assertArrayEquals((byte[])((byte[])testEvent.getMessage().getPayload().getValue()), (byte[])payload.toString().getBytes());
    }

    private void createAndRegisterTransformersEndpointBuilderService() throws Exception {
        TestEventTransformer trans1 = new TestEventTransformer();
        trans1.setName("OptimusPrime");
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)trans1);
        TestEventTransformer trans2 = new TestEventTransformer();
        trans2.setName("Bumblebee");
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)trans2);
        ArrayList<TestEventTransformer> transformers = new ArrayList<TestEventTransformer>();
        transformers.add(trans1);
        transformers.add(trans2);
    }

    @Test
    public void testFlowVarNamesAddImmutable() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)"whatever")).addVariable("test", (Object)"val").build();
        this.expectedException.expect(UnsupportedOperationException.class);
        event.getVariables().keySet().add("other");
    }

    @Test
    public void testFlowVarNamesRemoveImmutable() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)"whatever")).addVariable("test", (Object)"val").build();
        event = CoreEvent.builder((CoreEvent)event).addVariable("test", (Object)"val").build();
        this.expectedException.expect(UnsupportedOperationException.class);
        event.getVariables().keySet().remove("test");
    }

    @Test
    public void testFlowVarsNotShared() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)"whatever")).addVariable("foo", (Object)"bar").build();
        event = CoreEvent.builder((CoreEvent)event).addVariable("foo", (Object)"bar").build();
        CoreEvent copy = CoreEvent.builder((CoreEvent)event).build();
        copy = CoreEvent.builder((CoreEvent)copy).addVariable("foo", (Object)"bar2").build();
        Assert.assertEquals((Object)"bar", (Object)((TypedValue)event.getVariables().get("foo")).getValue());
        Assert.assertEquals((Object)"bar2", (Object)((TypedValue)copy.getVariables().get("foo")).getValue());
    }

    @Test
    public void securityContextCopy() throws Exception {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        CoreEvent event = CoreEvent.builder((CoreEvent)this.testEvent()).securityContext(securityContext).build();
        CoreEvent eventCopy = CoreEvent.builder((CoreEvent)event).message(Message.of((Object)"copy")).build();
        Assert.assertThat((Object)securityContext, (Matcher)Matchers.sameInstance((Object)eventCopy.getSecurityContext()));
    }

    @Test
    public void securityContextSerialization() throws Exception {
        Transformer transformer = this.createSerializableToByteArrayTransformer();
        transformer.setMuleContext(muleContext);
        CoreEvent event = CoreEvent.builder((CoreEvent)this.testEvent()).securityContext(this.createTestAuthentication()).build();
        Serializable serialized = (Serializable)this.createSerializableToByteArrayTransformer().transform((Object)event);
        Assert.assertNotNull((Object)serialized);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        CoreEvent deserialized = (CoreEvent)trans.transform((Object)serialized);
        Assert.assertThat((Object)deserialized.getSecurityContext().getAuthentication().getPrincipal(), (Matcher)CoreMatchers.is((Object)event.getSecurityContext().getAuthentication().getPrincipal()));
        Assert.assertThat(deserialized.getSecurityContext().getAuthentication().getProperties().get("key1"), (Matcher)CoreMatchers.is(event.getSecurityContext().getAuthentication().getProperties().get("key1")));
        Assert.assertThat((Object)deserialized.getSecurityContext().getAuthentication().getCredentials(), (Matcher)CoreMatchers.is((Object)event.getSecurityContext().getAuthentication().getCredentials()));
    }

    private SecurityContext createTestAuthentication() {
        DefaultMuleAuthentication auth = new DefaultMuleAuthentication((Credentials)new DefaultMuleCredentials("dan", new char[]{'d', 'f'}));
        SecurityContext securityContext = new DefaultSecurityContextFactory().create(auth.setProperties(Collections.singletonMap("key1", "value1")));
        return securityContext;
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        private TestEventTransformer() {
        }

        public Object doTransform(Object src, Charset encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

