/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ExceptionHelperTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty verbose = new SystemProperty("mule.verbose.exceptions", "true"){

        public void before() throws Throwable {
            super.before();
            MuleException.refreshVerboseExceptions();
        }

        public void after() {
            super.after();
            MuleException.refreshVerboseExceptions();
        }
    };

    @BeforeClass
    public static void beforeClass() {
        MuleException.refreshVerboseExceptions();
    }

    @Test
    public void nestedExceptionRetrieval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"blah"));
        Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.nullValue());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        Assert.assertThat((Object)l, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        Assert.assertThat(info.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"info_1", (Object)"Imma in!"));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"info_2", (Object)"Imma out!"));
    }

    @Test
    public void summarizeWithDepthBeyondStackTraceLength() {
        Exception exception = this.getException();
        int numberOfStackFrames = exception.getStackTrace().length;
        int depth = numberOfStackFrames + 1;
        Throwable summary = ExceptionHelper.summarise((Throwable)exception, (int)depth);
        Assert.assertThat((Object)summary, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void getNonMuleExceptionCause() {
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), null)), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), null))), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException()))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException(new NullPointerException())))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new IllegalArgumentException()), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void filteredStackIncludingNonMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, input -> CollectionUtils.forAllDo(Collections.singleton(null), input1 -> {
                throw new RuntimeException((Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"foo")));
            }));
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.runtime.api.exception.DefaultMuleException\\)", "  " + ExceptionHelperTestCase.class.getName() + ".lambda\\$[^\\(]*\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.apache.commons.collections.CollectionUtils.forAllDo\\(CollectionUtils.java:[0-9]+\\)", "  " + ExceptionHelperTestCase.class.getName() + ".lambda\\$[^\\(]*\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  " + ExceptionHelperTestCase.class.getName() + ".generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 16) + " more...\\)"));
        }
    }

    @Test
    public void filteredStackIncludingMixedNonMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, input -> {
                Comparable<Object> exceptionComparable = o -> {
                    throw new RuntimeException((Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"foo")));
                };
                Collections.sort(Arrays.asList(exceptionComparable, exceptionComparable), ComparableComparator.getInstance());
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.runtime.api.exception.DefaultMuleException\\)", "  " + ExceptionHelperTestCase.class.getName() + ".lambda\\$[^\\(]*\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.apache.commons.collections.comparators.ComparableComparator.compare\\(ComparableComparator.java:[0-9]+\\)", "  java.util.*", "  java.util.*", "  java.util.*", "  java.util.*", "  java.util.*", "  " + ExceptionHelperTestCase.class.getName() + ".lambda\\$[^\\(]*\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  " + ExceptionHelperTestCase.class.getName() + ".generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 16) + " more...\\)"));
        }
    }

    @Test
    public void filteredStackAllMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, input -> {
                throw new RuntimeException((Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"foo")));
            });
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.runtime.api.exception.DefaultMuleException\\)", "  " + ExceptionHelperTestCase.class.getName() + ".lambda\\$[^\\(]*\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  " + ExceptionHelperTestCase.class.getName() + ".generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  " + ExceptionHelperTestCase.class.getName() + ".generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 15) + " more...\\)"));
        }
    }

    private void generateStackEntries(int calls, Closure closure) {
        if (calls == 0) {
            closure.execute(null);
        } else {
            this.generateStackEntries(--calls, closure);
        }
    }

    private Exception getException() {
        DefaultMuleException innerMuleException = new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"bar"), (Throwable)new Exception("blah"));
        innerMuleException.addInfo("info_1", (Object)"Imma in!");
        DefaultMuleException outerMuleException = new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"foo"), (Throwable)innerMuleException);
        outerMuleException.addInfo("info_1", (Object)"Imma out!");
        outerMuleException.addInfo("info_2", (Object)"Imma out!");
        return outerMuleException;
    }

    private static final class StringByLineMatcher
    extends TypeSafeMatcher<String> {
        private final String[] expectedEntries;
        private int i = 0;

        private StringByLineMatcher(String ... expectedEntries) {
            this.expectedEntries = expectedEntries;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("line %d matches \"%s\"", this.i, this.expectedEntries[this.i]));
        }

        protected boolean matchesSafely(String item) {
            String[] stackEntries = item.split(System.lineSeparator());
            if (stackEntries.length != this.expectedEntries.length) {
                return false;
            }
            for (String expectedEntry : this.expectedEntries) {
                if (!stackEntries[this.i].matches(expectedEntry)) {
                    return false;
                }
                ++this.i;
            }
            return true;
        }

        public static StringByLineMatcher matchesLineByLine(String ... expectedEntries) {
            return new StringByLineMatcher(expectedEntries);
        }
    }
}

