/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.execution;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.PhaseSupportTestHelper;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.FlowProcessingPhase;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.mule.runtime.core.privileged.exception.ResponseDispatchException;
import org.mule.runtime.core.privileged.execution.FlowProcessingPhaseTemplate;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class FlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RequestResponseFlowProcessingPhaseTemplate mockRequestResponseTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResponseDispatchException mockResponseDispatchException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ServerNotificationManager notificationManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageSource messageSource;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContextWithRegistries muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Registry registry;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, extraInterfaces={Component.class})
    private FlowConstruct flowConstruct;
    private FlowProcessingPhase phase;

    public FlowProcessingPhaseTestCase() {
        this.phase = new FlowProcessingPhase(this.registry);
    }

    @Before
    public void before() {
        Mockito.when((Object)this.notificationManager.isNotificationEnabled((Class)org.mockito.Matchers.any(Class.class))).thenReturn((Object)true);
        Mockito.when((Object)this.muleContext.getNotificationManager()).thenReturn((Object)this.notificationManager);
        this.phase.setMuleContext((MuleContext)this.muleContext);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByName((String)org.mockito.Matchers.any())).thenReturn(Optional.of(this.flowConstruct));
        this.phase.setRegistry(registry);
        ComponentLocation mockComponentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)mockComponentLocation.getRootContainerName()).thenReturn((Object)"root");
        Mockito.when((Object)this.messageSource.getLocation()).thenReturn((Object)mockComponentLocation);
        Mockito.when((Object)this.mockContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockContext.getMessageSource()).thenReturn((Object)this.messageSource);
    }

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<FlowProcessingPhaseTemplate>(FlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void callSendResponseForRequestResponseTemplate() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        this.verifyOnlySuccessfulWasCalled();
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
    }

    @Test
    public void successfulPhaseExecutionInOrder() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        InOrder inOrderVerify = Mockito.inOrder((Object[])new Object[]{this.mockContext, this.mockRequestResponseTemplate, this.mockNotifier});
        ((MessageProcessContext)inOrderVerify.verify((Object)this.mockContext, Mockito.atLeastOnce())).getTransactionConfig();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).getEvent();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).beforeRouteEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).routeEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).afterRouteEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).afterSuccessfulProcessingFlow((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((PhaseResultNotifier)inOrderVerify.verify((Object)this.mockNotifier)).phaseSuccessfully();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).afterFailureProcessingFlow((MuleException)this.mockMessagingException);
    }

    @Test
    public void doNotSendResponseWhenFlowExecutionFailsSendingResponseAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockResponseDispatchException).when((Object)this.mockRequestResponseTemplate)).sendResponseToClient((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate, (VerificationMode)Mockito.never())).afterFailureProcessingFlow((MuleException)this.mockMessagingException);
    }

    @Test
    public void doNotSendFailureResponseWhenFlowExecutionFailsSendingResponseAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockMessagingException).when((Object)this.mockRequestResponseTemplate)).sendResponseToClient((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).afterFailureProcessingFlow((MuleException)this.mockMessagingException);
    }

    @Test
    public void responseNotificationFired() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenAnswer(invocation -> (CoreEvent)invocation.getArgumentAt(0, CoreEvent.class));
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ConnectorMessageNotification.class);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).fireNotification((Notification)notificationCaptor.capture());
        Assert.assertThat((Object)notificationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ConnectorMessageNotification)notificationCaptor.getValue()).getAction().getActionId(), (Matcher)Is.is((Object)805));
    }

    @Test
    public void errorResponseNotificationFired() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ConnectorMessageNotification.class);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).fireNotification((Notification)notificationCaptor.capture());
        Assert.assertThat((Object)notificationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ConnectorMessageNotification)notificationCaptor.getValue()).getAction().getActionId(), (Matcher)Is.is((Object)806));
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)org.mockito.Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseSuccessfully();
    }
}

