/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.execution;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TransactionTemplateTestUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transaction.xa.IllegalTransactionStateException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class TransactionalExecutionTemplateTestCase
extends AbstractMuleTestCase {
    protected MuleContext mockMuleContext = MuleContextUtils.mockContextWithServices();
    protected FlowConstruct mockFlow = (FlowConstruct)Mockito.mock(FlowConstruct.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}).defaultAnswer(Mockito.RETURNS_DEEP_STUBS));
    @Mock
    protected CoreEvent RETURN_VALUE;
    @Spy
    protected TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Spy
    protected TestTransaction mockNewTransaction = new TestTransaction(this.mockMuleContext);
    @Mock
    protected ExternalTransactionAwareTransactionFactory mockExternalTransactionFactory;
    @Mock
    protected MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected CoreEvent mockEvent;
    @Mock
    protected FlowExceptionHandler mockMessagingExceptionHandler;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void prepareEvent() throws RegistrationException {
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)Message.of((Object)""));
    }

    @Before
    public void unbindTransaction() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        Mockito.when((Object)this.mockMessagingException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
    }

    @Test
    public void testActionIndifferentConfig() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(6);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNeverAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionNeverAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        executionTemplate.execute(this.getEmptyTransactionCallback());
    }

    @Test
    public void testActionNoneAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    @Test
    public void testActionNoneAndTxForCommit() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
    }

    @Test
    public void testActionNoneAndTxForRollback() throws Exception {
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
    }

    @Test
    public void testActionNoneAndXaTx() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
            return this.mockTransaction;
        });
        this.mockTransaction.setXA(true);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Transaction externalTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenReturn((Object)externalTransaction);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testActionAlwaysBeginAndCommitTxAndCommitNewTx() throws Exception {
        this.expectedException.expect(IllegalTransactionStateException.class);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        executionTemplate.execute(this.getEmptyTransactionCallback());
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionAlwaysBeginAndRollbackTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction)).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionAlwaysBeginAndRollbackTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = executionTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction)).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction, (VerificationMode)Mockito.never())).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction)).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction, (VerificationMode)Mockito.never())).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = executionTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction)).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionAlwaysJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        executionTemplate.execute(this.getRollbackTransactionCallback());
    }

    @Test
    public void testActionAlwaysJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    @Test
    public void testActionBeginOrJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionBeginOrJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    @Test
    public void testActionJoinIfPossibleAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionJoinIfPossibleAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Object result = executionTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.never())).rollback();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    protected ExecutionTemplate createExecutionTemplate(TransactionConfig config) {
        return TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)this.mockMuleContext, (TransactionConfig)config);
    }

    protected ExecutionCallback getEmptyTransactionCallback() {
        return TransactionTemplateTestUtils.getEmptyTransactionCallback(this.RETURN_VALUE);
    }

    protected ExecutionCallback getRollbackTransactionCallback() {
        return TransactionTemplateTestUtils.getRollbackTransactionCallback(this.RETURN_VALUE);
    }
}

