/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.lifecycle;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.ClusterNodeNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.mule.runtime.core.api.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class PrimaryNodeLifecycleNotificationListenerTestCase
extends AbstractMuleTestCase {
    @Mock
    private NotificationListenerRegistry notificationRegistrer;
    @Mock
    private Startable mockStartable;
    @Mock
    private ClusterNodeNotification mockServerNotification;
    private StartableAndLifecycleState mockStartableAndLifecycleState;
    private StartableAndLifecycleStateEnabled mockStartableAndLifecycleStateEnabled;
    private PrimaryNodeLifecycleNotificationListener notificationListener;

    @Before
    public void setUpTest() {
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener(this.mockStartable, this.notificationRegistrer);
    }

    @Test
    public void testRegister() {
        this.notificationListener.register();
        ((NotificationListenerRegistry)Mockito.verify((Object)this.notificationRegistrer, (VerificationMode)Mockito.times((int)1))).registerListener((NotificationListener)this.notificationListener);
    }

    @Test
    public void testUnregister() {
        this.notificationListener.unregister();
        ((NotificationListenerRegistry)Mockito.verify((Object)this.notificationRegistrer, (VerificationMode)Mockito.times((int)1))).unregisterListener((NotificationListener)this.notificationListener);
    }

    @Test
    public void testOnNotificationWithStartable() throws MuleException {
        this.notificationListener.onNotification(this.mockServerNotification);
        ((Startable)Mockito.verify((Object)this.mockStartable, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateStarted() throws MuleException {
        this.mockStartableAndLifecycleState = (StartableAndLifecycleState)Mockito.mock(StartableAndLifecycleState.class);
        Mockito.when((Object)this.mockStartableAndLifecycleState.isStarted()).thenReturn((Object)true);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleState, this.notificationRegistrer);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleState)Mockito.verify((Object)this.mockStartableAndLifecycleState, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateStopped() throws MuleException {
        this.mockStartableAndLifecycleState = (StartableAndLifecycleState)Mockito.mock(StartableAndLifecycleState.class);
        Mockito.when((Object)this.mockStartableAndLifecycleState.isStarted()).thenReturn((Object)false);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleState, this.notificationRegistrer);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleState)Mockito.verify((Object)this.mockStartableAndLifecycleState, (VerificationMode)Mockito.times((int)0))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateEnabledStarted() throws MuleException {
        this.mockStartableAndLifecycleStateEnabled = (StartableAndLifecycleStateEnabled)Mockito.mock(StartableAndLifecycleStateEnabled.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockStartableAndLifecycleStateEnabled.getLifecycleState().isStarted()).thenReturn((Object)true);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleStateEnabled, this.notificationRegistrer);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleStateEnabled)Mockito.verify((Object)this.mockStartableAndLifecycleStateEnabled, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateEnabledStopped() throws MuleException {
        this.mockStartableAndLifecycleStateEnabled = (StartableAndLifecycleStateEnabled)Mockito.mock(StartableAndLifecycleStateEnabled.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockStartableAndLifecycleStateEnabled.getLifecycleState().isStarted()).thenReturn((Object)false);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleStateEnabled, this.notificationRegistrer);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleStateEnabled)Mockito.verify((Object)this.mockStartableAndLifecycleStateEnabled, (VerificationMode)Mockito.times((int)0))).start();
    }

    private static interface StartableAndLifecycleState
    extends Startable,
    LifecycleState {
    }

    private static interface StartableAndLifecycleStateEnabled
    extends Startable,
    LifecycleStateEnabled {
    }
}

