/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.message;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ErrorBuilderTestCase
extends AbstractMuleTestCase {
    private static final String EXCEPTION_MESSAGE = "message";
    private final ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);

    @Test
    public void buildErrorFromException() {
        RuntimeException exception = new RuntimeException(EXCEPTION_MESSAGE);
        Error error = ErrorBuilder.builder((Throwable)exception).errorType(this.mockErrorType).build();
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)this.mockErrorType));
        Assert.assertThat((Object)error.getChildErrors(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void buildErrorFromMuleException() {
        DefaultMuleException exception = new DefaultMuleException((Throwable)new RuntimeException(EXCEPTION_MESSAGE));
        Error error = ErrorBuilder.builder((Throwable)exception).errorType(this.mockErrorType).build();
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getDescription(), (Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)this.mockErrorType));
        Assert.assertThat((Object)error.getChildErrors(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void buildError() {
        String detailedDescription = "detailed description";
        String description = "description";
        ErrorType errorType = this.mockErrorType;
        Message errorMessage = Message.of(null);
        IllegalArgumentException exception = new IllegalArgumentException("some message");
        Error error = ErrorBuilder.builder().errorType(errorType).description(description).detailedDescription(detailedDescription).exception((Throwable)exception).errorMessage(errorMessage).build();
        Assert.assertThat((Object)error.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Is.is((Object)detailedDescription));
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)errorType));
        Assert.assertThat((Object)error.getErrorMessage(), (Matcher)Is.is((Object)errorMessage));
        Assert.assertThat((Object)error.getChildErrors(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void buildErrorFromCustomException() {
        Error error = ErrorBuilder.builder((Throwable)((Object)new ComposedErrorMessageAwareException(I18nMessageFactory.createStaticMessage((String)EXCEPTION_MESSAGE)))).errorType(this.mockErrorType).build();
        Assert.assertThat((Object)error.getDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Matcher)Matchers.instanceOf(ComposedErrorMessageAwareException.class)));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)this.mockErrorType));
        Assert.assertThat((Object)error.getErrorMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        List childErrors = error.getChildErrors();
        Assert.assertThat((Object)childErrors, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((Error)childErrors.get(0)).getCause(), (Matcher)Is.is((Matcher)Matchers.instanceOf(RuntimeException.class)));
        Assert.assertThat((Object)((Error)childErrors.get(1)).getCause(), (Matcher)Is.is((Matcher)Matchers.instanceOf(IOException.class)));
    }

    @Test
    public void givesStringRepresentation() {
        ErrorType anyError = ErrorTypeBuilder.builder().namespace("MULE").identifier("ANY").build();
        ErrorType testError = ErrorTypeBuilder.builder().namespace("MULE").identifier("TEST").parentErrorType(anyError).build();
        Error error = ErrorBuilder.builder((Throwable)((Object)new ComposedErrorMessageAwareException(I18nMessageFactory.createStaticMessage((String)EXCEPTION_MESSAGE), testError))).errorType(testError).build();
        Assert.assertThat((Object)error.toString(), (Matcher)Is.is((Object)"\norg.mule.runtime.core.internal.message.ErrorBuilder$ErrorImplementation\n{\n  description=message\n  detailedDescription=message\n  errorType=MULE:TEST\n  cause=org.mule.runtime.core.api.message.ErrorBuilderTestCase$ComposedErrorMessageAwareException\n  errorMessage=\norg.mule.runtime.core.internal.message.DefaultMessageBuilder$MessageImplementation\n{\n  payload=java.lang.String\n  mediaType=*/*\n  attributes=null\n  attributesMediaType=*/*\n  exceptionPayload=<not set>\n}\n  childErrors=[\norg.mule.runtime.core.internal.message.ErrorBuilder$ErrorImplementation\n{\n  description=unknown description\n  detailedDescription=unknown description\n  errorType=MULE:TEST\n  cause=java.lang.RuntimeException\n  errorMessage=-\n  childErrors=[]\n}, \norg.mule.runtime.core.internal.message.ErrorBuilder$ErrorImplementation\n{\n  description=unknown description\n  detailedDescription=unknown description\n  errorType=MULE:TEST\n  cause=java.io.IOException\n  errorMessage=-\n  childErrors=[]\n}]\n}"));
    }

    private class ComposedErrorMessageAwareException
    extends MuleException
    implements ErrorMessageAwareException,
    ComposedErrorException {
        private ErrorType errorType;

        public ComposedErrorMessageAwareException(I18nMessage message) {
            this(message, errorBuilderTestCase.mockErrorType);
        }

        public ComposedErrorMessageAwareException(I18nMessage message, ErrorType errorType) {
            super(message);
            this.errorType = errorType;
        }

        public List<Error> getErrors() {
            return Arrays.asList(ErrorBuilder.builder((Throwable)new RuntimeException()).errorType(this.errorType).build(), ErrorBuilder.builder((Throwable)new IOException()).errorType(this.errorType).build());
        }

        public Message getErrorMessage() {
            return Message.of((Object)"test");
        }
    }
}

