/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.object;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.object.AbstractObjectFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractObjectFactoryTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testInitialisationFailureWithoutObjectClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        this.addMockComponentLocation((Component)factory);
        try {
            factory.initialise();
            Assert.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    @Test
    public void testInstanceFailureGetInstanceWithoutObjectClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        this.addMockComponentLocation((Component)factory);
        try {
            factory.getInstance(muleContext);
            Assert.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateWithClassButDoNotInitialise() throws Exception {
        DummyObjectFactory factory = new DummyObjectFactory(Object.class);
        this.assertObjectClassAndName(factory);
    }

    @Test
    public void testCreateWithClassNameButDoNotInitialise() throws Exception {
        DummyObjectFactory factory = new DummyObjectFactory(Object.class.getName());
        this.assertObjectClassAndName(factory);
    }

    @Test
    public void testSetObjectClassNameButDoNotInitialise() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClassName(Object.class.getName());
        this.assertObjectClassAndName(factory);
    }

    @Test
    public void testSetObjectClassButDoNotInitialise() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClass(Object.class);
        this.assertObjectClassAndName(factory);
    }

    private void assertObjectClassAndName(AbstractObjectFactory factory) {
        Assert.assertEquals(Object.class, (Object)factory.getObjectClass());
        Assert.assertEquals((Object)Object.class.getName(), (Object)factory.getObjectClassName());
    }

    @Test
    public void testInitialiseWithClass() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClass(Object.class);
        ((MuleContextWithRegistries)muleContext).getRegistry().applyProcessorsAndLifecycle((Object)factory);
        Assert.assertNotNull((Object)factory.getInstance(muleContext));
    }

    @Test
    public void testInitialiseWithClassName() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        factory.setObjectClassName(Object.class.getName());
        ((MuleContextWithRegistries)muleContext).getRegistry().applyProcessorsAndLifecycle((Object)factory);
        Assert.assertNotNull((Object)factory.getInstance(muleContext));
    }

    @Test
    public void testDispose() throws Exception {
        AbstractObjectFactory factory = this.getUninitialisedObjectFactory();
        this.addMockComponentLocation((Component)factory);
        factory.setObjectClass(Object.class);
        ((MuleContextWithRegistries)muleContext).getRegistry().applyProcessorsAndLifecycle((Object)factory);
        factory.dispose();
        try {
            factory.getInstance(muleContext);
            Assert.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public abstract AbstractObjectFactory getUninitialisedObjectFactory();

    @Test
    public abstract void testGetObjectClass() throws Exception;

    @Test
    public abstract void testGet() throws Exception;

    private static class DummyObjectFactory
    extends AbstractObjectFactory {
        public DummyObjectFactory(String className) {
            super(className);
        }

        public DummyObjectFactory(Class<?> klass) {
            super(klass);
        }
    }
}

