/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.mule.runtime.core.internal.processor.util.InvokerMessageProcessorUtil;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ArgumentSplitterTestCase
extends AbstractMuleTestCase {
    @Test
    public void whenSingleMuleExpressionProcessedAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"#[function(a)]");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[function(a)]"));
    }

    @Test
    public void whenSingleMuleExpressionWithInnerArrayProcessedAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"#[function(a), [1, 2, 3]]");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[function(a),[1,2,3]]"));
    }

    @Test
    public void whenSingleMuleExpressionWithSeveralNestedArraysProcessedAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"#[[[function(a), a, b, b], a], [1, 2, 3]]");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[[[function(a),a,b,b],a],[1,2,3]]"));
    }

    @Test
    public void whenMoreThanOneMuleExpressionsProcessedAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"#[[[function(a), a, b, c], a]], #[1, 2, 3]");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[[[function(a),a,b,c],a]]"));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[1,2,3]"));
    }

    @Test
    public void whenThreeMuleExpressionsProcessedAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"#[1, 2, 3], #[[[function(a), a, b, c], a]], #[[1, 2], [3, 4]]");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[1,2,3]"));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[[[function(a),a,b,c],a]]"));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[[1,2],[3,4]]"));
    }

    @Test
    public void whenValidExpressionSpacesWithinThenProcessAsExpected() {
        List args = InvokerMessageProcessorUtil.splitArgumentsExpression((String)"      #[1, 2, 3]         ,       #[2, 3, 4] ");
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[1,2,3]"));
        MatcherAssert.assertThat((Object)args, (Matcher)IsCollectionContaining.hasItem((Object)"#[2,3,4]"));
    }
}

