/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MapProcessorTestCase
extends AbstractMuleContextTestCase {
    @Mock
    private BaseEventContext eventContext;
    private CoreEvent event;
    private RuntimeException exception;
    private Error error;
    @Rule
    public ExpectedException thrown;
    private Processor testProcessor;
    private Processor testProcessorReturnsNull;
    private Processor testProcessorThrowsException;
    private Processor testProcessorThrowsError;

    public MapProcessorTestCase() {
        this.event = CoreEvent.builder((EventContext)this.eventContext).message(Message.of((Object)"test")).build();
        this.exception = new RuntimeException(){};
        this.error = new LinkageError();
        this.thrown = ExpectedException.none();
        this.testProcessor = event -> CoreEvent.builder((EventContext)this.eventContext).message(Message.of((Object)"test")).build();
        this.testProcessorReturnsNull = event -> CoreEvent.builder((EventContext)this.eventContext).message(Message.of(null)).build();
        this.testProcessorThrowsException = event -> {
            throw this.exception;
        };
        this.testProcessorThrowsError = event -> {
            throw this.error;
        };
    }

    @Test
    public void mapBlocking() throws Exception {
        CoreEvent result = this.testProcessor.process(this.event);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapStreamBlockingGet() {
        CoreEvent result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessor).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapStreamSubscribe() throws Exception {
        CoreEvent result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessor).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapBlockingNullResult() throws Exception {
        CoreEvent result = this.testProcessorReturnsNull.process(this.event);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamBlockingGetNullResult() {
        CoreEvent result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessorReturnsNull).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeNullResult() throws Exception {
        CoreEvent result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessorReturnsNull).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapBlockingExceptionThrown() throws Exception {
        this.thrown.expect(CoreMatchers.is((Object)this.exception));
        this.testProcessorThrowsException.process(this.event);
    }

    @Test
    public void mapStreamBlockingGetExceptionThrown() throws Throwable {
        CoreEvent result;
        this.thrown.expect(CoreMatchers.is((Object)this.exception));
        try {
            result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsException).block();
        }
        catch (Exception e) {
            throw Exceptions.unwrap((Throwable)e);
        }
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeExceptionThrown() throws Exception {
        Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsException).onErrorResume(throwable -> {
            Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Object)this.exception));
            return Mono.empty();
        }).subscribe();
    }

    @Test
    public void mapBlockingErrorThrown() throws Exception {
        this.thrown.expect(CoreMatchers.is((Object)this.error));
        this.testProcessorThrowsError.process(this.event);
    }

    @Test
    public void mapStreamBlockingGetErrorThrown() throws Throwable {
        CoreEvent result = null;
        try {
            result = (CoreEvent)Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsError).block();
        }
        catch (Exception e) {
            Throwable problem = Exceptions.unwrap((Throwable)e);
            Assert.assertThat((Object)problem, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MuleFatalException.class)));
            Assert.assertThat((Object)problem.getCause(), (Matcher)CoreMatchers.is((Object)this.error));
        }
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeErrorThrown() throws Exception {
        Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsError).onErrorResume(throwable -> {
            Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MuleFatalException.class)));
            Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.is((Object)this.error));
            return Mono.empty();
        }).block();
    }
}

