/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.InternalProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
public class MessageProcessorsTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeException exception = new IllegalArgumentException();
    private BaseEventContext eventContext;
    private CoreEvent input;
    private CoreEvent output;
    private CoreEvent response;
    private Flow flow;
    private Publisher<CoreEvent> responsePublisher;
    private InternalReactiveProcessor map = publisher -> Mono.from((Publisher)publisher).map(in -> this.output);
    private InternalReactiveProcessor ackAndStop = publisher -> Mono.from((Publisher)publisher).flatMap(in -> {
        ((BaseEventContext)in.getContext()).success();
        return Mono.empty();
    });
    private InternalReactiveProcessor respondAndStop = publisher -> Mono.from((Publisher)publisher).flatMap(in -> {
        ((BaseEventContext)in.getContext()).success(this.response);
        return Mono.empty();
    });
    private InternalReactiveProcessor ackAndMap = publisher -> Mono.from((Publisher)publisher).doOnNext(in -> ((BaseEventContext)in.getContext()).success()).map(in -> this.output);
    private InternalReactiveProcessor respondAndMap = publisher -> Mono.from((Publisher)publisher).doOnNext(in -> ((BaseEventContext)in.getContext()).success(this.response)).map(in -> this.output);
    private InternalReactiveProcessor error = publisher -> Mono.from((Publisher)publisher).map(in -> {
        throw this.exception;
    });

    @Before
    public void setup() throws MuleException {
        this.flow = (Flow)Mockito.mock(Flow.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        OnErrorPropagateHandler exceptionHandler = new OnErrorPropagateHandler();
        exceptionHandler.setMuleContext(muleContext);
        exceptionHandler.setNotificationFirer((NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class));
        exceptionHandler.initialise();
        Mockito.when((Object)this.flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        this.eventContext = (BaseEventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        this.input = CoreEvent.builder((EventContext)this.eventContext).message(Message.of((Object)"Test Message")).build();
        this.output = CoreEvent.builder((EventContext)this.eventContext).message(Message.of((Object)"Test Message")).build();
        this.response = CoreEvent.builder((EventContext)this.eventContext).message(Message.of((Object)"Test Message")).build();
        this.responsePublisher = this.eventContext.getResponsePublisher();
    }

    @After
    public void tearDown() throws MuleException {
        if (this.flow != null) {
            this.flow.stop();
            this.flow.dispose();
        }
    }

    @Test
    public void processToApplyMap() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.map), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void processToApplyMapInChain() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.map)), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void processToApplyMapInFlow() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.map)).getMessage(), (Matcher)CoreMatchers.is((Object)this.output.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.output));
    }

    @Test
    public void processToApplyAckAndStop() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.ackAndStop), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyAckAndStopInChain() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.ackAndStop)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyAckAndStopInFlow() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.ackAndStop)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyRespondAndStop() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.respondAndStop), (Matcher)CoreMatchers.is((Object)this.response));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyRespondAndStopInChain() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.respondAndStop)), (Matcher)CoreMatchers.is((Object)this.response));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyRespondAndStopInFlow() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.respondAndStop)).getMessage(), (Matcher)CoreMatchers.is((Object)this.response.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyAckAndMap() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.ackAndMap), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyAckAndMapInChain() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.ackAndMap)), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyAckAndMapInFlow() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.ackAndMap)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processToApplyRespondAndMap() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.respondAndMap), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyRespondAndMapInChain() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.respondAndMap)), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyRespondAndMapInFlow() throws Exception {
        Assert.assertThat((Object)MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.respondAndMap)).getMessage(), (Matcher)CoreMatchers.is((Object)this.response.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processToApplyError() throws Exception {
        this.thrown.expect(CoreMatchers.is((Object)this.exception));
        try {
            MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.error);
        }
        finally {
            Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void processToApplyErrorInChain() throws Exception {
        try {
            MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.error));
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.is((Object)this.exception));
        }
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
        this.thrown.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.is((Object)this.exception)));
        Mono.from(this.responsePublisher).block();
    }

    @Test
    public void processToApplyErrorInFlow() throws Exception {
        try {
            MessageProcessors.processToApply((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.error));
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.is((Object)this.exception));
        }
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
        this.thrown.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.is((Object)this.exception)));
        Mono.from(this.responsePublisher).block();
    }

    @Test
    public void processMap() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.map)).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat(Mono.from(this.responsePublisher).toFuture().get(), (Matcher)CoreMatchers.equalTo((Object)this.output));
    }

    @Test
    public void processMapInChain() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.map))).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat(Mono.from(this.responsePublisher).toFuture().get(), (Matcher)CoreMatchers.equalTo((Object)this.output));
    }

    @Test
    public void processMapInFlow() throws Exception {
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.map))).block()).getMessage(), (Matcher)CoreMatchers.is((Object)this.output.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.output));
    }

    @Test
    public void processAckAndStop() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.ackAndStop)).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processAckAndStopInChain() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.ackAndStop))).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processAckAndStopInFlow() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.ackAndStop))).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processRespondAndStop() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.respondAndStop)).block(), (Matcher)CoreMatchers.is((Object)this.response));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processRespondAndStopInChain() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.respondAndStop))).block(), (Matcher)CoreMatchers.is((Object)this.response));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processRespondAndStopInFlow() throws Exception {
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.respondAndStop))).block()).getMessage(), (Matcher)CoreMatchers.is((Object)this.response.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processAckAndMap() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.ackAndMap)).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processAckAndMapInChain() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.ackAndMap))).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processAckAndMapInFlow() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.ackAndMap))).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void processRespondAndMap() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.respondAndMap)).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processRespondAndMapInChain() throws Exception {
        Assert.assertThat((Object)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.respondAndMap))).block(), (Matcher)CoreMatchers.is((Object)this.output));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processRespondAndMapInFlow() throws Exception {
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.respondAndMap))).block()).getMessage(), (Matcher)CoreMatchers.is((Object)this.response.getMessage()));
        Assert.assertThat((Object)Mono.from(this.responsePublisher).block(), (Matcher)CoreMatchers.is((Object)this.response));
    }

    @Test
    public void processError() throws Exception {
        this.thrown.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.is((Object)this.exception)));
        try {
            Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.error)).block();
        }
        finally {
            Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
            Mono.from(this.responsePublisher).toFuture().whenComplete((event, throwable) -> Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.equalTo((Object)this.exception)));
        }
    }

    @Test
    public void processErrorInChain() throws Exception {
        try {
            Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createChain(this.error))).block();
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)t.getCause().getCause(), (Matcher)CoreMatchers.is((Object)this.exception));
        }
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
        this.thrown.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.is((Object)this.exception)));
        Mono.from(this.responsePublisher).block();
    }

    @Test
    public void processErrorInFlow() throws Exception {
        try {
            Mono.from((Publisher)MessageProcessors.process((CoreEvent)this.input, (ReactiveProcessor)this.createFlow(this.error))).block();
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)t.getCause().getCause(), (Matcher)CoreMatchers.is((Object)this.exception));
        }
        Assert.assertThat((Object)Mono.from(this.responsePublisher).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
        this.thrown.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.is((Object)this.exception)));
        Mono.from(this.responsePublisher).block();
    }

    private Processor createChain(ReactiveProcessor processor) throws InitialisationException {
        MessageProcessorChain chain = MessageProcessors.newChain(Optional.empty(), (Processor[])new Processor[]{new ReactiveProcessorToProcessorAdaptor(processor)});
        chain.setMuleContext(muleContext);
        return chain;
    }

    private Processor createFlow(ReactiveProcessor processor) throws MuleException {
        this.flow = Flow.builder((String)"test", (MuleContext)muleContext).processors(new Processor[]{new ReactiveProcessorToProcessorAdaptor(processor)}).build();
        this.flow.initialise();
        this.flow.start();
        return this.flow;
    }

    @FunctionalInterface
    private static interface InternalReactiveProcessor
    extends ReactiveProcessor,
    InternalProcessor {
    }

    private static class ReactiveProcessorToProcessorAdaptor
    implements Processor,
    InternalProcessor {
        ReactiveProcessor delegate;

        ReactiveProcessorToProcessorAdaptor(ReactiveProcessor delegate) {
            this.delegate = delegate;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new UnsupportedOperationException();
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return (Publisher)this.delegate.apply(publisher);
        }
    }
}

