/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
@Feature(value="Streaming")
@Story(value="Object Streaming")
public class StreamingIteratorTestCase {
    private static final int PAGE_SIZE = 100;
    private static final int TOP = 3000;
    private PagingProvider<Object, String> delegate = new TestPagingProvider();
    @InjectMocks
    private Producer<List<String>> producer = new Producer<List<String>>(){

        public int getSize() {
            return (Integer)StreamingIteratorTestCase.this.delegate.getTotalResults(new Object()).get();
        }

        public void close() throws IOException {
            try {
                StreamingIteratorTestCase.this.delegate.close(new Object());
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }

        public List<String> produce() {
            return StreamingIteratorTestCase.this.delegate.getPage(new Object());
        }
    };

    @Test
    @Description(value="Fully consume the iterator")
    public void iterateStreaming() throws Exception {
        StreamingIterator<String> it = this.newIterator();
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        Assert.assertEquals((long)count, (long)3000L);
        it.close();
    }

    @Test
    @Description(value="A closed iterator doesn't have next")
    public void closedIterator() throws Exception {
        StreamingIterator<String> it = this.newIterator();
        it.close();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    @Description(value="Iterator doesn't have next if consumer is closed")
    public void closedConsumer() throws Exception {
        ListConsumer consumer = new ListConsumer(this.producer);
        ConsumerStreamingIterator it = new ConsumerStreamingIterator((Consumer)consumer);
        consumer.close();
        MatcherAssert.assertThat((Object)it.hasNext(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Description(value="iterator has size")
    public void size() throws Exception {
        StreamingIterator<String> it = this.newIterator();
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)Matchers.is((Object)3000));
    }

    private StreamingIterator<String> newIterator() {
        ListConsumer consumer = new ListConsumer(this.producer);
        return new ConsumerStreamingIterator((Consumer)consumer);
    }

    public class TestPagingProvider
    implements PagingProvider<Object, String> {
        long counter = 0L;

        public List<String> getPage(Object con) {
            if (this.counter < 3000L) {
                ArrayList<String> page = new ArrayList<String>(100);
                for (int i = 0; i < 100; ++i) {
                    ++this.counter;
                    String value = RandomStringUtils.randomAlphabetic((int)5000);
                    page.add(value);
                }
                return page;
            }
            return null;
        }

        public void close(Object con) throws MuleException {
        }

        public Optional<Integer> getTotalResults(Object con) {
            return Optional.of(3000);
        }
    }
}

