/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestTransactionFactory;

public class MuleTransactionConfigTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testActionAndStringConversion() {
        MuleTransactionConfig c = new MuleTransactionConfig();
        c.setMuleContext(muleContext);
        c.setAction((byte)1);
        Assert.assertEquals((Object)"ALWAYS_BEGIN", (Object)c.getActionAsString());
        c.setAction((byte)3);
        Assert.assertEquals((Object)"ALWAYS_JOIN", (Object)c.getActionAsString());
        c.setAction((byte)2);
        Assert.assertEquals((Object)"BEGIN_OR_JOIN", (Object)c.getActionAsString());
        c.setAction((byte)4);
        Assert.assertEquals((Object)"JOIN_IF_POSSIBLE", (Object)c.getActionAsString());
        c.setAction((byte)0);
        Assert.assertEquals((Object)"NONE", (Object)c.getActionAsString());
        c.setAction((byte)6);
        Assert.assertEquals((Object)"INDIFFERENT", (Object)c.getActionAsString());
    }

    @Test
    public void testDefaults() throws Exception {
        MuleTransactionConfig c = new MuleTransactionConfig(1);
        c.setMuleContext(muleContext);
        Assert.assertEquals((String)"Wrong default TX timeout", (long)30000L, (long)c.getTimeout());
    }

    @Test
    public void testTransactionJoinIfPossible() throws TransactionException {
        MuleTransactionConfig txConfig = new MuleTransactionConfig(4);
        txConfig.setMuleContext(muleContext);
        txConfig.setFactory((TransactionFactory)new TestTransactionFactory());
        Assert.assertFalse((boolean)txConfig.isTransacted());
    }

    @Test
    public void testFailNoFactory() {
        MuleTransactionConfig txConfig = new MuleTransactionConfig(1);
        txConfig.setMuleContext(muleContext);
        try {
            txConfig.isTransacted();
            Assert.fail((String)"isTransacted() must fail if no factory is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

