/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.privileged.transaction.AbstractSingleResourceTransaction;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TransactionNotificationsTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testTransactionNotifications() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        DummyTransaction transaction = new DummyTransaction(muleContext);
        ((NotificationListenerRegistry)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationListenerRegistry.class)).registerListener((NotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(TransactionNotification notification) {
                if (new IntegerAction(1201).equals((Object)notification.getAction())) {
                    Assert.assertEquals((Object)"begin", (Object)notification.getActionName());
                    latch.countDown();
                } else if (new IntegerAction(1202).equals((Object)notification.getAction())) {
                    Assert.assertEquals((Object)"commit", (Object)notification.getActionName());
                    latch.countDown();
                } else if (new IntegerAction(1203).equals((Object)notification.getAction())) {
                    Assert.assertEquals((Object)"rollback", (Object)notification.getActionName());
                    latch.countDown();
                }
            }
        }, arg_0 -> TransactionNotificationsTestCase.lambda$testTransactionNotifications$0((Transaction)transaction, arg_0));
        transaction.begin();
        transaction.commit();
        transaction.rollback();
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"There are still some notifications left unfired.", (long)0L, (long)latch.getCount());
    }

    private static /* synthetic */ boolean lambda$testTransactionNotifications$0(Transaction transaction, TransactionNotification notification) {
        return transaction.getId().equals(notification.getResourceIdentifier());
    }

    private class DummyTransaction
    extends AbstractSingleResourceTransaction {
        private DummyTransaction(MuleContext muleContext) {
            super(muleContext);
        }

        protected Class getResourceType() {
            return null;
        }

        protected Class getKeyType() {
            return null;
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
        }

        protected void doRollback() throws TransactionException {
        }
    }
}

