/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;

public class TransactionTemplateTestUtils {
    public static ExecutionCallback<CoreEvent> getEmptyTransactionCallback(CoreEvent returnObject) {
        return () -> returnObject;
    }

    public static ExecutionCallback<CoreEvent> getRollbackTransactionCallback(CoreEvent returnObject) {
        return () -> {
            TransactionCoordination.getInstance().getTransaction().setRollbackOnly();
            return returnObject;
        };
    }

    public static ExecutionCallback<CoreEvent> getCommitTransactionCallback(CoreEvent returnObject) {
        return () -> {
            TransactionCoordination.getInstance().getTransaction().commit();
            return returnObject;
        };
    }

    public static ExecutionCallback<CoreEvent> getFailureTransactionCallback() throws Exception {
        return () -> {
            throw (MessagingException)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_MOCKS.get());
        };
    }

    public static ExecutionCallback<CoreEvent> getFailureTransactionCallback(MessagingException mockMessagingException) throws Exception {
        return () -> {
            throw mockMessagingException;
        };
    }

    public static ExecutionCallback<CoreEvent> getFailureTransactionCallbackStartsTransaction(MessagingException mockMessagingException, Transaction mockTransaction) {
        return () -> {
            TransactionCoordination.getInstance().bindTransaction(mockTransaction);
            throw mockMessagingException;
        };
    }
}

