/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction.xa;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transaction.XaTransaction;
import org.mule.runtime.core.privileged.transaction.xa.XaResourceFactoryHolder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class XaTransactionTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private TransactionManager mockTransactionManager;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder1;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder2;
    @Mock
    private XAResource mockXaResource;

    @Before
    public void setUpMuleContext() throws RegistrationException {
        Mockito.when((Object)this.mockMuleContext.getTransactionManager()).thenReturn((Object)this.mockTransactionManager);
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getId()).thenReturn((Object)"appName");
    }

    @Test
    public void recognizeDifferentWrappersOfSameResource() throws Exception {
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        Object resourceFactory = new Object();
        Object resource = new Object();
        Mockito.when((Object)this.mockXaResourceFactoryHolder1.getHoldObject()).thenReturn(resourceFactory);
        Mockito.when((Object)this.mockXaResourceFactoryHolder2.getHoldObject()).thenReturn(resourceFactory);
        xaTransaction.bindResource((Object)this.mockXaResourceFactoryHolder1, resource);
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.getResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)resource));
    }

    @Test
    public void isRollbackOnly() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)tx.getStatus()).thenReturn((Object)0).thenReturn((Object)3).thenReturn((Object)1).thenReturn((Object)4).thenReturn((Object)9);
        Mockito.when((Object)this.mockTransactionManager.getTransaction()).thenReturn((Object)tx);
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        xaTransaction.begin();
        junit.framework.Assert.assertFalse((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertFalse((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
    }

    @Test
    public void setTxTimeoutWhenEnlistingResource() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockTransactionManager.getTransaction()).thenReturn((Object)tx);
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        int timeoutValue = 1500;
        int timeoutValueInSeconds = 1;
        xaTransaction.setTimeout(timeoutValue);
        xaTransaction.begin();
        xaTransaction.enlistResource(this.mockXaResource);
        ((XAResource)Mockito.verify((Object)this.mockXaResource)).setTransactionTimeout(timeoutValueInSeconds);
    }

    @Test
    public void setsTransactionTimeoutOnBegin() throws Exception {
        int timeoutMillis = 5000;
        int timeoutSecs = 5;
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        xaTransaction.setTimeout(5000);
        xaTransaction.begin();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockTransactionManager});
        ((TransactionManager)inOrder.verify((Object)this.mockTransactionManager)).setTransactionTimeout(5);
        ((TransactionManager)inOrder.verify((Object)this.mockTransactionManager)).begin();
    }
}

