/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transformer;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransformerSourceTypeEnforcementTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleConfiguration.getDefaultEncoding()).thenReturn((Object)Charsets.UTF_8.name());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
    }

    @Test
    public void rejectsBadInputIfEnforcementOn() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        try {
            transformer.transform((Object)"TEST");
            Assert.fail((String)"Transformation should fail because source type is not supported");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Test
    public void rejectsBadInputUsingDefaultEnforcement() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        try {
            transformer.transform((Object)"TEST");
            Assert.fail((String)"Transformation should fail because source type is not supported");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Test
    public void transformsValidSourceTypeWithNoCheckForEnforcement() throws TransformerException {
        AbstractTransformer transformer = this.createDummyTransformer(true);
        transformer.sourceTypes.add(DataType.STRING);
        transformer.setReturnDataType(DataType.STRING);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        Object result = transformer.transform((Object)"TEST");
        Assert.assertEquals((Object)"TRANSFORMED", (Object)result);
    }

    private AbstractTransformer createDummyTransformer(boolean ignoreBadInput) {
        AbstractTransformer result = new AbstractTransformer(){

            protected Object doTransform(Object src, Charset enc) throws TransformerException {
                return "TRANSFORMED";
            }
        };
        result.sourceTypes.add(DataType.BYTE_ARRAY);
        result.setMuleContext(this.muleContext);
        result.setIgnoreBadInput(ignoreBadInput);
        return result;
    }
}

