/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.IOException;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ExceptionUtilsTestCase
extends AbstractMuleTestCase {
    private static final String ERROR_MESSAGE = "Excepted Error Message";

    @Test
    public void testContainsType() {
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new IllegalArgumentException(), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException()), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), NullPointerException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), RuntimeException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), Exception.class));
        Assert.assertFalse((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), IOException.class));
    }

    @Test
    public void testFullStackTraceWithoutMessage() throws Exception {
        String mainMessage = "main message 112312 [][] ''' ... sdfsd blah";
        String causeMessage = "cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t" + System.lineSeparator() + "sdfsllki";
        RuntimeException e = new RuntimeException("main message 112312 [][] ''' ... sdfsd blah", new RuntimeException(causeMessage));
        String withoutMessage = ExceptionUtils.getFullStackTraceWithoutMessages((Throwable)e);
        String fullStackTrace = org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace((Throwable)e);
        String[] linesWithoutMessage = withoutMessage.split(System.lineSeparator());
        String[] lines = fullStackTrace.split(System.lineSeparator());
        Assert.assertEquals((long)lines.length, (long)linesWithoutMessage.length);
        for (int i = 0; i < lines.length; ++i) {
            Assert.assertTrue((boolean)lines[i].contains(linesWithoutMessage[i]));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains("main message 112312 [][] ''' ... sdfsd blah"));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains(causeMessage));
        }
    }

    @Test
    public void extractExceptionOfType() {
        Exception exception = new Exception(new Throwable((Throwable)new ConnectionException((Throwable)new IOException(new NullPointerException()))));
        Optional ioException = ExceptionUtils.extractOfType((Throwable)exception, IOException.class);
        Assert.assertThat((Object)ioException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IOException)ioException.get()).getCause(), (Matcher)IsInstanceOf.instanceOf(NullPointerException.class));
    }

    @Test
    public void extractExceptionOfSubtype() {
        Exception exception = new Exception(new IllegalStateException(new Error(new RuntimeException(new IOException()))));
        Optional runtimeException = ExceptionUtils.extractOfType((Throwable)exception, RuntimeException.class);
        Assert.assertThat((Object)runtimeException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(runtimeException.get(), (Matcher)IsInstanceOf.instanceOf(IllegalStateException.class));
    }

    @Test
    public void extractExceptionCauseOf() {
        Exception exception = new Exception(new IOException((Throwable)new ConnectionException(ERROR_MESSAGE, (Throwable)new NullPointerException())));
        Optional throwable = ExceptionUtils.extractCauseOfType((Throwable)exception, IOException.class);
        Assert.assertThat((Object)throwable.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(throwable.get(), (Matcher)IsInstanceOf.instanceOf(ConnectionException.class));
        Assert.assertThat((Object)((Throwable)throwable.get()).getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void extractRootConnectionException() {
        Exception withConnectionExceptionCause = new Exception((Throwable)new ConnectionException(ERROR_MESSAGE, (Throwable)new ConnectionException((Throwable)new NullPointerException())));
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)withConnectionExceptionCause);
        Assert.assertThat((Object)connectionException.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((ConnectionException)connectionException.get()).getMessage(), (Matcher)Is.is((Object)ERROR_MESSAGE));
    }

    @Test
    public void extractMissingConnectionException() {
        Exception withoutConnectionException = new Exception(new NullPointerException());
        Optional exception = ExceptionUtils.extractConnectionException((Throwable)withoutConnectionException);
        Assert.assertThat((Object)exception.isPresent(), (Matcher)Is.is((Object)false));
    }
}

