/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class IOUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testLoadingResourcesAsStream() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"log4j2-test.xml", ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)is);
        is = IOUtils.getResourceAsStream((String)"does-not-exist.properties", ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false);
        Assert.assertNull((Object)is);
    }

    @Test
    public void bufferSize() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).write((byte[])org.mockito.Matchers.any(byte[].class), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt());
    }

    @Test
    public void increaseBufferSizeViaSystemProperty() throws Exception {
        int newBufferSize = 8192;
        MuleTestUtils.testWithSystemProperty((String)"mule.streaming.bufferSize", (String)Integer.toString(8192), () -> {
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
            OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader newClassLoader = new URLClassLoader(((URLClassLoader)contextClassLoader).getURLs(), null);
            Class clazz = ClassUtils.loadClass((String)IOUtils.class.getCanonicalName(), (ClassLoader)newClassLoader);
            try {
                Thread.currentThread().setContextClassLoader(newClassLoader);
                clazz.getMethod("copyLarge", InputStream.class, OutputStream.class).invoke((Object)clazz, in, out);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).write((byte[])org.mockito.Matchers.any(byte[].class), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt());
        });
    }

    @Test
    public void convertsToStringWithEncoding() throws Exception {
        Charset encoding = Charset.forName("EUC-JP");
        String encodedText = "\u3053";
        ByteArrayInputStream in = new ByteArrayInputStream("\u3053".getBytes(encoding));
        String converted = IOUtils.toString((InputStream)in, (Charset)encoding);
        Assert.assertThat((Object)converted, (Matcher)Matchers.equalTo((Object)"\u3053"));
    }
}

