/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MessagingExceptionResolverTestCase
extends AbstractMuleTestCase {
    private static final String ERROR_MESSAGE = "Messaging Error Message";
    private static final String EXPECTED_MESSAGE = "THIS MESSAGE SHOULD BE THROWN";
    private Component processor = (Component)Mockito.mock(Component.class);
    private CoreEvent event;
    private MuleContext context = (MuleContext)Mockito.mock(MuleContext.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{PrivilegedMuleContext.class}));
    private FlowCallStack flowCallStack = (FlowCallStack)Mockito.mock(FlowCallStack.class);
    private Message message = (Message)Mockito.mock(Message.class);
    private ComponentIdentifier ci = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
    private final TransformerException TRANSFORMER_EXCEPTION = new TransformerException(I18nMessageFactory.createStaticMessage((String)"TRANSFORMER"));
    private final ConnectionException CONNECTION_EXCEPTION = new ConnectionException("CONNECTION PROBLEM");
    private final MuleFatalException FATAL_EXCEPTION = new MuleFatalException(I18nMessageFactory.createStaticMessage((String)"CRITICAL!!!!!!"));
    private final Error ERROR = new Error("AN ERROR");
    private final ErrorTypeRepository repository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
    private final ErrorTypeLocator locator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)this.repository);
    private final ErrorType UNKNOWN = this.locator.lookupErrorType(Exception.class);
    private final ErrorType FATAL = this.locator.lookupErrorType(this.FATAL_EXCEPTION.getClass());
    private final ErrorType CRITICAL = this.locator.lookupErrorType(this.ERROR.getClass());
    private final ErrorType CONNECTION = this.locator.lookupErrorType(((Object)((Object)this.CONNECTION_EXCEPTION)).getClass());
    private final ErrorType TRANSFORMER = this.locator.lookupErrorType(((Object)((Object)this.TRANSFORMER_EXCEPTION)).getClass());
    private final MessagingExceptionResolver resolver = new MessagingExceptionResolver(this.processor);

    @Before
    public void setup() throws MuleException {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue(null, DataType.STRING));
        Mockito.when((Object)this.message.getAttributes()).thenReturn((Object)new TypedValue(null, DataType.STRING));
        this.event = (CoreEvent)Mockito.spy((Object)this.getEventBuilder().message(this.message).build());
        Mockito.when((Object)((PrivilegedMuleContext)this.context).getErrorTypeLocator()).thenReturn((Object)this.locator);
    }

    @Test
    public void resolveExceptionWithCriticalUnderlyingError() {
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(this.CONNECTION, null);
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        MessagingException me = this.newMessagingException(this.ERROR, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.CONNECTION);
    }

    @Test
    public void resolveExceptionWithUnknownUnderlyingError() {
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(this.CONNECTION, null);
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        MessagingException me = this.newMessagingException(new Exception(), this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.CONNECTION);
    }

    @Test
    public void resolveWithoutAnyErrors() {
        MessagingException me = this.newMessagingException(new Exception(), this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.UNKNOWN);
        this.assertExceptionMessage(resolved.getMessage(), ERROR_MESSAGE);
    }

    @Test
    public void resolveCriticalError() {
        MessagingException me = this.newMessagingException(this.ERROR, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.CRITICAL);
        this.assertExceptionMessage(resolved.getMessage(), this.ERROR.getMessage());
    }

    @Test
    public void resolveMultipleCriticalErrors() {
        LinkageError t = new LinkageError("this one is NOT expected", new Error(new Error("expected")));
        MessagingException me = this.newMessagingException(t, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.CRITICAL);
        this.assertExceptionMessage(resolved.getMessage(), "expected");
    }

    @Test
    public void resolveWithAnEventThatCarriesError() {
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(this.TRANSFORMER, null);
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        MessagingException me = this.newMessagingException(new Exception(), this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.TRANSFORMER);
        this.assertExceptionMessage(resolved.getMessage(), ERROR_MESSAGE);
    }

    @Test
    public void resolveWithMultipleErrors() {
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(this.TRANSFORMER, this.TRANSFORMER_EXCEPTION);
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        Exception cause = new Exception(new ConnectionException((Throwable)this.FATAL_EXCEPTION));
        MessagingException me = this.newMessagingException(cause, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.FATAL);
        this.assertExceptionMessage(resolved.getMessage(), this.FATAL_EXCEPTION.getMessage());
    }

    @Test
    public void resolveTopExceptionWithSameError() {
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(this.TRANSFORMER, this.TRANSFORMER_EXCEPTION);
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        MuleFatalException cause = new MuleFatalException(I18nMessageFactory.createStaticMessage((String)EXPECTED_MESSAGE), (Throwable)new LinkageError("!"));
        MessagingException me = this.newMessagingException((Throwable)cause, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, this.FATAL);
        this.assertExceptionMessage(resolved.getMessage(), EXPECTED_MESSAGE);
    }

    @Test
    public void resolveWithParentInChain() {
        ErrorType withParent = ErrorTypeBuilder.builder().parentErrorType(this.CONNECTION).identifier("CONNECT").namespace("TEST").build();
        Optional<org.mule.runtime.api.message.Error> surfaceError = this.mockError(withParent, new Exception());
        Mockito.when((Object)this.event.getError()).thenReturn(surfaceError);
        ConnectionException cause = new ConnectionException("Some Connection Error", (Throwable)new Exception());
        MessagingException me = this.newMessagingException(cause, this.event, this.processor);
        MessagingException resolved = this.resolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, withParent);
        this.assertExceptionMessage(resolved.getMessage(), ERROR_MESSAGE);
    }

    @Test
    public void resolveCorrectConnectionException() {
        ErrorType expected = ErrorTypeBuilder.builder().namespace("NS").identifier("CONNECTION").parentErrorType(this.CONNECTION).build();
        ErrorTypeLocator locator = ErrorTypeLocator.builder((ErrorTypeRepository)this.repository).addComponentExceptionMapper(this.ci, ExceptionMapper.builder().addExceptionMapping(ConnectionException.class, expected).build()).defaultExceptionMapper(ExceptionMapper.builder().build()).defaultError(this.UNKNOWN).build();
        Mockito.when((Object)((PrivilegedMuleContext)this.context).getErrorTypeLocator()).thenReturn((Object)locator);
        MessagingException me = this.newMessagingException(this.CONNECTION_EXCEPTION, this.event, this.processor);
        MessagingExceptionResolver anotherResolver = new MessagingExceptionResolver((Component)new TestProcessor());
        MessagingException resolved = anotherResolver.resolve(me, this.context);
        this.assertExceptionErrorType(resolved, expected);
        this.assertExceptionMessage(resolved.getMessage(), "CONNECTION PROBLEM");
    }

    private void assertExceptionMessage(String result, String expected) {
        String expectedMessage = String.format("%s.", expected);
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)expectedMessage));
    }

    private void assertExceptionErrorType(MessagingException me, ErrorType expected) {
        Optional error = me.getEvent().getError();
        Assert.assertThat((String)("No error found, expecting error with error type [" + expected + "]"), (Object)error.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((org.mule.runtime.api.message.Error)error.get()).getErrorType(), (Matcher)Is.is((Object)expected));
    }

    private MessagingException newMessagingException(Throwable e, CoreEvent event, Component processor) {
        return new MessagingException(I18nMessageFactory.createStaticMessage((String)ERROR_MESSAGE), event, e, processor);
    }

    private Optional<org.mule.runtime.api.message.Error> mockError(ErrorType errorType, Throwable cause) {
        org.mule.runtime.api.message.Error error = (org.mule.runtime.api.message.Error)Mockito.mock(org.mule.runtime.api.message.Error.class);
        Mockito.when((Object)error.getErrorType()).thenReturn((Object)errorType);
        Mockito.when((Object)error.getCause()).thenReturn((Object)cause);
        return Optional.of(error);
    }

    public class TestProcessor
    implements AnnotatedProcessor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessagingExceptionResolverTestCase.this.nullPayloadEvent();
        }

        public Object getAnnotation(QName name) {
            return ComponentAnnotations.ANNOTATION_NAME.equals(name) ? MessagingExceptionResolverTestCase.this.ci : null;
        }

        public Map<QName, Object> getAnnotations() {
            return Collections.emptyMap();
        }

        public void setAnnotations(Map<QName, Object> annotations) {
        }

        public ComponentLocation getLocation() {
            return null;
        }

        public Location getRootContainerLocation() {
            return null;
        }
    }
}

