/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.WildcardAttributeEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WildcardAttributeEvaluatorTestCase
extends AbstractMuleTestCase {
    @Test
    public void testStartsWithWildcard() {
        List<String> testValues = Arrays.asList("MULE", "MULEMAN", "EMULE", "MULE\\*", "\\*MULE");
        List<String> expectedValues = Arrays.asList("MULE", "MULEMAN", "MULE\\*");
        this.testScenario("MULE*", testValues, expectedValues);
    }

    @Test
    public void testEndsWithWildcard() {
        List<String> testValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        List<String> expectedValues = Arrays.asList("MULE", "EMULE", "\\*MULE");
        this.testScenario("*MULE", testValues, expectedValues);
    }

    @Test
    public void testAllWildcard() {
        List<String> testValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        List<String> expectedValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        this.testScenario("*", testValues, expectedValues);
    }

    @Test
    public void testWithEscapedCharactersOnly() {
        WildcardAttributeEvaluator wildcardAttributeEvaluator = new WildcardAttributeEvaluator("\\*");
        Assert.assertThat((Object)wildcardAttributeEvaluator.hasWildcards(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWithEscapedCharactersAndWildcards() {
        List<String> testValues = Arrays.asList("\\*MULE", "EMULE", "MAN-MULE-MAN", "", "MULE\\*", "\\*MULE\\*");
        List<String> expectedValues = Arrays.asList("\\*MULE", "\\*MULE\\*");
        this.testScenario("\\*MULE*", testValues, expectedValues);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCallConstructorWithNull() {
        new WildcardAttributeEvaluator(null);
    }

    private void testScenario(String attributeValue, List<String> testValues, List<String> expectedValues) {
        WildcardAttributeEvaluator wildcardAttributeEvaluator = new WildcardAttributeEvaluator(attributeValue);
        Assert.assertThat((Object)wildcardAttributeEvaluator.hasWildcards(), (Matcher)Is.is((Object)true));
        final ArrayList resultingValues = new ArrayList();
        wildcardAttributeEvaluator.processValues(testValues, new WildcardAttributeEvaluator.MatchCallback(){

            public void processMatch(String matchedValue) {
                resultingValues.add(matchedValue);
            }
        });
        Assert.assertThat((Object)expectedValues.size(), (Matcher)Is.is((Object)resultingValues.size()));
        for (String expectedValue : expectedValues) {
            Assert.assertThat((Object)resultingValues.contains(expectedValue), (Matcher)Is.is((Object)true));
        }
    }
}

