/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.internal.util.collection.ImmutableMapCollector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Kiwi;

@SmallTest
public class ImmutableMapCollectorTestCase
extends AbstractMuleTestCase {
    private final ImmutableMapCollector<Fruit, String, Fruit> collector = new ImmutableMapCollector(f -> f.getClass().getName(), f -> f);

    @Test
    public void collect() {
        List<Fruit> fruits = Arrays.asList(new Apple(), new Banana(), new Kiwi());
        Map map = (Map)fruits.stream().collect(this.collector);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)3));
        fruits.forEach(fruit -> {
            Fruit value = (Fruit)map.get(fruit.getClass().getName());
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.sameInstance((Object)fruit));
        });
    }

    @Test
    public void emptyMap() {
        Map map = (Map)new ArrayList().stream().collect(this.collector);
        Assert.assertThat((Object)map.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }
}

