/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.func;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class OnceTestCase
extends AbstractMuleTestCase {
    @Test
    public void runOnlyOnce() {
        CountingRunnable runnable = new CountingRunnable();
        Once.RunOnce once = Once.of((CheckedRunnable)runnable);
        once.runOnce();
        once.runOnce();
        Assert.assertThat((Object)runnable.getInvokationCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void runUntilSuccessful() {
        CountingRunnable runnable = new CountingRunnable();
        Once.RunOnce once = Once.of(() -> {
            runnable.runChecked();
            int count = runnable.getInvokationCount();
            if (count < 3) {
                throw new RuntimeException();
            }
        });
        for (int i = 0; i < 5; ++i) {
            try {
                once.runOnce();
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        Assert.assertThat((Object)runnable.getInvokationCount(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void concurrentRun() {
        Latch controlLath = new Latch();
        Latch testLath = new Latch();
        CountingRunnable runnable = new CountingRunnable();
        Once.RunOnce once = Once.of((CheckedRunnable)runnable);
        new Thread(() -> {
            this.await(controlLath);
            once.runOnce();
        }).start();
        new Thread(() -> {
            controlLath.release();
            once.runOnce();
            testLath.release();
        }).start();
        this.await(testLath);
        Assert.assertThat((Object)runnable.getInvokationCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void consumeOnlyOnce() {
        CountingConsumer consumer = new CountingConsumer();
        Once.ConsumeOnce once = Once.of((CheckedConsumer)consumer);
        once.consumeOnce((Object)"chu chu");
        once.consumeOnce((Object)"ua ua ua");
        Assert.assertThat((Object)consumer.getInvokationCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void consumeUntilSuccessful() {
        CountingConsumer consumer = new CountingConsumer();
        Once.ConsumeOnce once = Once.of(value -> {
            consumer.accept(value);
            int count = consumer.getInvokationCount();
            if (count < 3) {
                throw new RuntimeException();
            }
        });
        for (int i = 0; i < 5; ++i) {
            try {
                once.consumeOnce((Object)"value");
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        Assert.assertThat((Object)consumer.getInvokationCount(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void concurrentConsume() {
        Latch controlLath = new Latch();
        Latch testLath = new Latch();
        CountingConsumer consumer = new CountingConsumer();
        Once.ConsumeOnce once = Once.of((CheckedConsumer)consumer);
        new Thread(() -> {
            this.await(controlLath);
            once.consumeOnce((Object)"s");
        }).start();
        new Thread(() -> {
            controlLath.release();
            once.consumeOnce((Object)"s");
            testLath.release();
        }).start();
        this.await(testLath);
        Assert.assertThat((Object)consumer.getInvokationCount(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void await(Latch latch) {
        try {
            Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class CountingConsumer
    implements CheckedConsumer<String> {
        private AtomicInteger invokationCount = new AtomicInteger(0);

        private CountingConsumer() {
        }

        public void acceptChecked(String s) throws Throwable {
            this.invokationCount.addAndGet(1);
        }

        public int getInvokationCount() {
            return this.invokationCount.get();
        }
    }

    private class CountingRunnable
    implements CheckedRunnable {
        private AtomicInteger invokationCount = new AtomicInteger(0);

        private CountingRunnable() {
        }

        public void runChecked() throws Exception {
            this.invokationCount.addAndGet(1);
        }

        public int getInvokationCount() {
            return this.invokationCount.get();
        }
    }
}

