/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.extension;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CoreExtensionModelTestCase
extends AbstractMuleContextTestCase {
    private static final ErrorModel errorMuleAny = ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build();
    private static ExtensionModel coreExtensionModel = MuleExtensionModelProvider.getExtensionModel();

    @Test
    public void consistentWithManifest() {
        Assert.assertThat((Object)coreExtensionModel.getName(), (Matcher)Matchers.is((Object)"mule"));
        Assert.assertThat((Object)coreExtensionModel.getDescription(), (Matcher)Matchers.is((Object)"Mule Runtime and Integration Platform: Core components"));
        Assert.assertThat((Object)coreExtensionModel.getVersion(), (Matcher)Matchers.is((Object)MuleManifest.getProductVersion()));
        Assert.assertThat((Object)coreExtensionModel.getVendor(), (Matcher)Matchers.is((Object)MuleManifest.getVendorName()));
        Assert.assertThat((Object)coreExtensionModel.getCategory(), (Matcher)Matchers.is((Object)Category.COMMUNITY));
    }

    @Test
    public void consistentWithSchema() {
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getPrefix(), (Matcher)Matchers.is((Object)"mule"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getNamespace(), (Matcher)Matchers.is((Object)"http://www.mulesoft.org/schema/mule/core"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getSchemaLocation(), (Matcher)Matchers.is((Object)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd"));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getSchemaVersion(), (Matcher)Matchers.is((Object)MuleExtensionModelProvider.MULE_VERSION));
        Assert.assertThat((Object)coreExtensionModel.getXmlDslModel().getXsdFileName(), (Matcher)Matchers.is((Object)"mule.xsd"));
    }

    @Test
    public void otherModels() {
        Assert.assertThat((Object)coreExtensionModel.getResources(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getSubTypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        SubTypesModel subTypesModel = (SubTypesModel)coreExtensionModel.getSubTypes().iterator().next();
        Assert.assertThat((Object)((TypeIdAnnotation)subTypesModel.getBaseType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Scheduler.class.getName()));
        Assert.assertThat((Object)subTypesModel.getSubTypes(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Iterator iterator = subTypesModel.getSubTypes().iterator();
        DefaultObjectType ffSchedulerType = (DefaultObjectType)iterator.next();
        Assert.assertThat((Object)ffSchedulerType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("frequency").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("frequency").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("startDelay").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("startDelay").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("timeUnit").get()).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ObjectFieldType)ffSchedulerType.getFieldByName("timeUnit").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        DefaultObjectType cronSchedulerType = (DefaultObjectType)iterator.next();
        Assert.assertThat((Object)cronSchedulerType.getFields(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("expression").get()).isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("expression").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("timeZone").get()).isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ObjectFieldType)cronSchedulerType.getFieldByName("timeZone").get()).getValue(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)coreExtensionModel.getExternalLibraryModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getImportedTypes(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getConfigurationModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getOperationModels(), (Matcher)IsCollectionWithSize.hasSize((int)8));
        Assert.assertThat((Object)coreExtensionModel.getConstructModels(), (Matcher)IsCollectionWithSize.hasSize((int)14));
        Assert.assertThat((Object)coreExtensionModel.getConnectionProviders(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)coreExtensionModel.getSourceModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)coreExtensionModel.getErrorModels(), (Matcher)IsCollectionContaining.hasItem((Object)ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TRANSFORMATION).withParent(errorMuleAny).build()));
        Assert.assertThat((Object)coreExtensionModel.getTypes(), (Matcher)IsCollectionWithSize.hasSize((int)5));
    }

    @Test
    public void flow() {
        ConstructModel flow = (ConstructModel)coreExtensionModel.getConstructModel("flow").get();
        Assert.assertThat((Object)flow.getStereotype().getType(), (Matcher)Matchers.is((Object)MuleStereotypes.FLOW.getType()));
        Assert.assertThat((Object)flow.allowsTopLevelDeclaration(), (Matcher)Matchers.is((Object)true));
        List paramModels = flow.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterModel initialState = (ParameterModel)paramModels.get(0);
        Assert.assertThat((Object)initialState.getName(), (Matcher)Matchers.is((Object)"initialState"));
        Assert.assertThat((Object)initialState.getDefaultValue(), (Matcher)Matchers.is((Object)"started"));
        ParameterModel maxConcurrency = (ParameterModel)paramModels.get(1);
        Assert.assertThat((Object)maxConcurrency.getName(), (Matcher)Matchers.is((Object)"maxConcurrency"));
        List nestedComponents = flow.getNestedComponents();
        Assert.assertThat((Object)nestedComponents, (Matcher)IsCollectionWithSize.hasSize((int)3));
        NestableElementModel source = (NestableElementModel)nestedComponents.get(0);
        Assert.assertThat((Object)source.getName(), (Matcher)Matchers.is((Object)"source"));
        Assert.assertThat((Object)source.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)source, (Matcher)Matchers.instanceOf(NestedComponentModel.class));
        Assert.assertThat((Object)((NestedComponentModel)source).getAllowedStereotypes(), (Matcher)Matchers.contains((Object[])new StereotypeModel[]{MuleStereotypes.SOURCE}));
        NestableElementModel chain = (NestableElementModel)nestedComponents.get(1);
        Assert.assertThat((Object)chain.getName(), (Matcher)Matchers.is((Object)"processors"));
        Assert.assertThat((Object)chain.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)chain, (Matcher)Matchers.instanceOf(NestedChainModel.class));
        Assert.assertThat((Object)((NestedChainModel)chain).getAllowedStereotypes().stream().anyMatch(s -> s.getType().equals(MuleStereotypes.PROCESSOR.getType())), (Matcher)Matchers.is((Object)true));
        NestableElementModel errorHandler = (NestableElementModel)nestedComponents.get(2);
        Assert.assertThat((Object)errorHandler.getName(), (Matcher)Matchers.is((Object)"errorHandler"));
        Assert.assertThat((Object)errorHandler.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)errorHandler, (Matcher)Matchers.instanceOf(NestedComponentModel.class));
        Assert.assertThat((Object)((NestedComponentModel)errorHandler).getAllowedStereotypes(), (Matcher)Matchers.contains((Object[])new StereotypeModel[]{MuleStereotypes.ERROR_HANDLER}));
    }

    @Test
    public void scheduler() {
        SourceModel schedulerModel = (SourceModel)coreExtensionModel.getSourceModel("scheduler").get();
        Assert.assertThat((Object)schedulerModel.getStereotype(), (Matcher)Matchers.is((Object)MuleStereotypes.SOURCE));
        Assert.assertThat((Object)schedulerModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)schedulerModel.hasResponse(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)schedulerModel.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)schedulerModel.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)schedulerModel.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)schedulerModel.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        List paramModels = schedulerModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertSchedulingStrategy((ParameterModel)paramModels.get(0));
    }

    @Test
    public void logger() {
        OperationModel loggerModel = (OperationModel)coreExtensionModel.getOperationModel("logger").get();
        Assert.assertThat((Object)loggerModel.getStereotype(), (Matcher)Matchers.is((Object)MuleStereotypes.PROCESSOR));
        Assert.assertThat((Object)loggerModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)loggerModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertOutputSameAsInput(loggerModel);
        List paramModels = loggerModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getName(), (Matcher)Matchers.is((Object)"message"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getType(), (Matcher)Matchers.instanceOf(StringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getName(), (Matcher)Matchers.is((Object)"level"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getName(), (Matcher)Matchers.is((Object)"category"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).getType(), (Matcher)Matchers.instanceOf(StringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void raiseError() {
        OperationModel raiseErrorModel = (OperationModel)coreExtensionModel.getOperationModel("raiseError").get();
        Assert.assertThat((Object)raiseErrorModel.getStereotype(), (Matcher)Matchers.is((Object)MuleStereotypes.PROCESSOR));
        Assert.assertThat((Object)raiseErrorModel.getErrorModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)raiseErrorModel.getExecutionType(), (Matcher)Matchers.is((Object)ExecutionType.CPU_LITE));
        this.assertOutputSameAsInput(raiseErrorModel);
        List paramModels = raiseErrorModel.getAllParameterModels();
        Assert.assertThat((Object)paramModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getName(), (Matcher)Matchers.is((Object)"type"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(0)).isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getName(), (Matcher)Matchers.is((Object)"description"));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).getType(), (Matcher)Matchers.instanceOf(StringType.class));
        Assert.assertThat((Object)((ParameterModel)paramModels.get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void foreach() {
        ConstructModel foreach = (ConstructModel)coreExtensionModel.getConstructModel("foreach").get();
        Assert.assertThat((Object)foreach.getNestedComponents().size(), (Matcher)Matchers.is((Object)1));
        NestableElementModel processorsChain = (NestableElementModel)foreach.getNestedComponents().get(0);
        Assert.assertThat((Object)processorsChain, (Matcher)Matchers.instanceOf(NestedChainModel.class));
        Assert.assertThat((Object)processorsChain.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)foreach.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        ParameterModel collection = (ParameterModel)foreach.getAllParameterModels().get(0);
        Assert.assertThat((Object)collection.getName(), (Matcher)Matchers.is((Object)"collection"));
        Assert.assertThat((Object)collection.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.REQUIRED));
        Assert.assertThat((Object)collection.getType(), (Matcher)Matchers.instanceOf(ArrayType.class));
        Assert.assertThat((Object)collection.getType().getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getClassname).orElse(""), (Matcher)Matchers.is((Object)Iterable.class.getName()));
        Assert.assertThat((Object)collection.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel batchSize = (ParameterModel)foreach.getAllParameterModels().get(1);
        Assert.assertThat((Object)batchSize.getName(), (Matcher)Matchers.is((Object)"batchSize"));
        Assert.assertThat((Object)batchSize.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)batchSize.getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)batchSize.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel rootMessageName = (ParameterModel)foreach.getAllParameterModels().get(2);
        Assert.assertThat((Object)rootMessageName.getName(), (Matcher)Matchers.is((Object)"rootMessageVariableName"));
        Assert.assertThat((Object)rootMessageName.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)rootMessageName.getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)rootMessageName.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel counter = (ParameterModel)foreach.getAllParameterModels().get(3);
        Assert.assertThat((Object)counter.getName(), (Matcher)Matchers.is((Object)"counterVariableName"));
        Assert.assertThat((Object)counter.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)counter.getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)counter.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void flowRef() {
        OperationModel flowRefModel = (OperationModel)coreExtensionModel.getOperationModel("flowRef").get();
        Assert.assertThat((Object)flowRefModel.getStereotype(), (Matcher)Matchers.is((Object)MuleStereotypes.PROCESSOR));
        this.assertAssociatedProcessorsChangeOutput(flowRefModel);
        Assert.assertThat((Object)flowRefModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"name"));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)flowRefModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)true));
        this.assertTarget((ParameterModel)flowRefModel.getAllParameterModels().get(1));
    }

    @Test
    public void idempotentMessageValidator() {
        OperationModel filterModel = (OperationModel)coreExtensionModel.getOperationModel("idempotentMessageValidator").get();
        Assert.assertThat((Object)filterModel.getStereotype(), (Matcher)Matchers.is((Object)MuleStereotypes.PROCESSOR));
        this.assertOutputSameAsInput(filterModel);
        Assert.assertThat((Object)filterModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"idExpression"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"valueExpression"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"storePrefix"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"objectStore"));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)filterModel.getAllParameterModels().get(3)).getAllowedStereotypes().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(((ParameterModel)filterModel.getAllParameterModels().get(3)).getAllowedStereotypes().get(0), (Matcher)Matchers.is((Object)MuleStereotypes.OBJECT_STORE));
    }

    @Test
    public void choice() {
        ConstructModel choiceModel = (ConstructModel)coreExtensionModel.getConstructModel("choice").get();
        Assert.assertThat((Object)choiceModel.allowsTopLevelDeclaration(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)choiceModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)choiceModel.getNestedComponents(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        NestedRouteModel whenRouteModel = (NestedRouteModel)choiceModel.getNestedComponents().get(0);
        Assert.assertThat((Object)whenRouteModel.getName(), (Matcher)Matchers.is((Object)"when"));
        Assert.assertThat((Object)whenRouteModel.getMinOccurs(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)whenRouteModel.getMaxOccurs(), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)whenRouteModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"expression"));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultBooleanType.class));
        Assert.assertThat((Object)((ParameterModel)whenRouteModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)true));
        NestedRouteModel otherwiseRouteModel = (NestedRouteModel)choiceModel.getNestedComponents().get(1);
        Assert.assertThat((Object)otherwiseRouteModel.getName(), (Matcher)Matchers.is((Object)"otherwise"));
        Assert.assertThat((Object)otherwiseRouteModel.getMinOccurs(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(otherwiseRouteModel.getMaxOccurs().get(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)otherwiseRouteModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void scatterGather() {
        ConstructModel scatterGatherModel = (ConstructModel)coreExtensionModel.getConstructModel("scatterGather").get();
        Assert.assertThat((Object)scatterGatherModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"timeout"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getName(), (Matcher)Matchers.is((Object)"maxConcurrency"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).getType(), (Matcher)Matchers.instanceOf(DefaultNumberType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(1)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getName(), (Matcher)Matchers.is((Object)"target"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(2)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(3)).getName(), (Matcher)Matchers.is((Object)"targetValue"));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(3)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.REQUIRED));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(3)).getType(), (Matcher)Matchers.instanceOf(StringType.class));
        Assert.assertThat((Object)((ParameterModel)scatterGatherModel.getAllParameterModels().get(3)).isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)scatterGatherModel.getNestedComponents(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        NestedRouteModel routeModel = (NestedRouteModel)scatterGatherModel.getNestedComponents().get(0);
        Assert.assertThat((Object)routeModel.getName(), (Matcher)Matchers.is((Object)"route"));
        Assert.assertThat((Object)routeModel.getMinOccurs(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)routeModel.getMaxOccurs(), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)routeModel.getAllParameterModels(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void async() {
        ConstructModel asyncModel = (ConstructModel)coreExtensionModel.getConstructModel("async").get();
        Assert.assertThat((Object)asyncModel.getNestedComponents(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        NestableElementModel processors = (NestableElementModel)asyncModel.getNestedComponents().get(0);
        Assert.assertThat((Object)processors, (Matcher)Matchers.instanceOf(NestedChainModel.class));
        Assert.assertThat((Object)processors.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asyncModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((ParameterModel)asyncModel.getAllParameterModels().get(0)).getName(), (Matcher)Matchers.is((Object)"name"));
        Assert.assertThat((Object)((ParameterModel)asyncModel.getAllParameterModels().get(0)).getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)((ParameterModel)asyncModel.getAllParameterModels().get(0)).getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)((ParameterModel)asyncModel.getAllParameterModels().get(0)).isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void tryScope() {
        ConstructModel tryModel = (ConstructModel)coreExtensionModel.getConstructModel("try").get();
        List allParameterModels = tryModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterModel action = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)action.getName(), (Matcher)Matchers.is((Object)"transactionalAction"));
        Assert.assertThat((Object)action.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)action.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)action.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel type = (ParameterModel)allParameterModels.get(1);
        Assert.assertThat((Object)type.getName(), (Matcher)Matchers.is((Object)"transactionType"));
        Assert.assertThat((Object)type.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)type.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)type.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void untilSuccessful() {
        ConstructModel tryModel = (ConstructModel)coreExtensionModel.getConstructModel("untilSuccessful").get();
        List allParameterModels = tryModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ParameterModel action = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)action.getName(), (Matcher)Matchers.is((Object)"maxRetries"));
        Assert.assertThat((Object)action.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultNumberType.class)));
        Assert.assertThat((Object)action.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)action.getDefaultValue(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)action.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel type = (ParameterModel)allParameterModels.get(1);
        Assert.assertThat((Object)type.getName(), (Matcher)Matchers.is((Object)"millisBetweenRetries"));
        Assert.assertThat((Object)type.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultNumberType.class)));
        Assert.assertThat((Object)type.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)type.getDefaultValue(), (Matcher)Matchers.is((Object)60000));
        Assert.assertThat((Object)type.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void firstSuccessful() {
        ConstructModel tryModel = (ConstructModel)coreExtensionModel.getConstructModel("firstSuccessful").get();
        List allParameterModels = tryModel.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void errorHandler() {
        ConstructModel errorHandlerModel = (ConstructModel)coreExtensionModel.getConstructModel("errorHandler").get();
        Assert.assertThat((Object)errorHandlerModel.allowsTopLevelDeclaration(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)errorHandlerModel.getStereotype().getType(), (Matcher)Matchers.is((Object)MuleStereotypes.ERROR_HANDLER.getType()));
        Assert.assertThat((Object)errorHandlerModel.getAllParameterModels(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ParameterModel ref = (ParameterModel)errorHandlerModel.getAllParameterModels().get(0);
        Assert.assertThat((Object)ref.getName(), (Matcher)Matchers.is((Object)"ref"));
        Assert.assertThat((Object)ref.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        Assert.assertThat((Object)ref.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)ref.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)ref.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((StereotypeModel)ref.getAllowedStereotypes().iterator().next()).getType(), (Matcher)Matchers.is((Object)MuleStereotypes.ERROR_HANDLER.getType()));
        Assert.assertThat((Object)errorHandlerModel.getNestedComponents(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        NestedRouteModel onErrorContinue = (NestedRouteModel)errorHandlerModel.getNestedComponents().get(0);
        this.verifyOnError(onErrorContinue);
        NestedRouteModel onErrorPropagate = (NestedRouteModel)errorHandlerModel.getNestedComponents().get(1);
        this.verifyOnError(onErrorPropagate);
        NestedComponentModel onErrorDelegate = (NestedComponentModel)errorHandlerModel.getNestedComponents().get(2);
        Assert.assertThat((Object)onErrorDelegate.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)onErrorDelegate.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((StereotypeModel)onErrorDelegate.getAllowedStereotypes().iterator().next()).getType(), (Matcher)Matchers.is((Object)MuleStereotypes.ON_ERROR.getType()));
        ConstructModel onError = (ConstructModel)coreExtensionModel.getConstructModel("onError").get();
        List allParameterModels = onError.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ParameterModel onErrorRef = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)onErrorRef.getName(), (Matcher)Matchers.is((Object)"ref"));
        Assert.assertThat((Object)onErrorRef.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)onErrorRef.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)onErrorRef.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)onErrorDelegate.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((StereotypeModel)onErrorDelegate.getAllowedStereotypes().iterator().next()).getType(), (Matcher)Matchers.is((Object)MuleStereotypes.ON_ERROR.getType()));
    }

    void verifyOnError(NestedRouteModel route) {
        List allParameterModels = route.getAllParameterModels();
        Assert.assertThat((Object)allParameterModels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        ParameterModel when = (ParameterModel)allParameterModels.get(0);
        Assert.assertThat((Object)when.getName(), (Matcher)Matchers.is((Object)"when"));
        Assert.assertThat((Object)when.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)when.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)when.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel type = (ParameterModel)allParameterModels.get(1);
        this.assertErrorType(type, "type");
        ParameterModel log = (ParameterModel)allParameterModels.get(2);
        Assert.assertThat((Object)log.getName(), (Matcher)Matchers.is((Object)"logException"));
        Assert.assertThat((Object)log.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBooleanType.class)));
        Assert.assertThat((Object)log.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)log.isRequired(), (Matcher)Matchers.is((Object)false));
        ParameterModel notifications = (ParameterModel)allParameterModels.get(3);
        Assert.assertThat((Object)notifications.getName(), (Matcher)Matchers.is((Object)"enableNotifications"));
        Assert.assertThat((Object)notifications.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultBooleanType.class)));
        Assert.assertThat((Object)notifications.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)notifications.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)notifications.getDefaultValue(), (Matcher)Matchers.is((Object)true));
    }

    private void assertOutputSameAsInput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(VoidType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(VoidType.class));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertComponentDeterminesOutput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(VoidType.class));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertAssociatedProcessorsChangeOutput(OperationModel model) {
        Assert.assertThat((Object)model.getOutput().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)model.getOutput().hasDynamicType(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)model.getOutputAttributes().getType(), (Matcher)Matchers.instanceOf(DefaultAnyType.class));
        Assert.assertThat((Object)model.getOutputAttributes().hasDynamicType(), (Matcher)Matchers.is((Object)false));
    }

    private void assertPayload(ParameterModel payloadParameterModel) {
        Assert.assertThat((Object)payloadParameterModel.getName(), (Matcher)Matchers.is((Object)"payload"));
        Assert.assertThat((Object)payloadParameterModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.SUPPORTED));
        Assert.assertThat((Object)payloadParameterModel.getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)((TypeIdAnnotation)payloadParameterModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Object.class.getName()));
        Assert.assertThat((Object)payloadParameterModel.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    private void assertTarget(ParameterModel targetParameterModel) {
        Assert.assertThat((Object)targetParameterModel.getName(), (Matcher)Matchers.is((Object)"target"));
        Assert.assertThat((Object)targetParameterModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)targetParameterModel.getType(), (Matcher)Matchers.instanceOf(DefaultStringType.class));
        Assert.assertThat((Object)targetParameterModel.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        Assert.assertThat((Object)targetParameterModel.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    private void assertErrorType(ParameterModel errorTypeParam, String paramName) {
        Assert.assertThat((Object)errorTypeParam.getName(), (Matcher)Matchers.is((Object)paramName));
        Assert.assertThat((Object)errorTypeParam.getType(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultStringType.class)));
        Assert.assertThat((Object)((EnumAnnotation)errorTypeParam.getType().getAnnotation(EnumAnnotation.class).get()).getValues(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Object[]{"ANY", "REDELIVERY_EXHAUSTED", "TRANSFORMATION", "EXPRESSION", "SECURITY", "CLIENT_SECURITY", "SERVER_SECURITY", "ROUTING", "CONNECTIVITY", "RETRY_EXHAUSTED", "TIMEOUT"}));
        Assert.assertThat((Object)errorTypeParam.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)errorTypeParam.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    private void assertSchedulingStrategy(ParameterModel paramModel) {
        Assert.assertThat((Object)paramModel.getName(), (Matcher)Matchers.is((Object)"schedulingStrategy"));
        Assert.assertThat((Object)paramModel.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)paramModel.getType(), (Matcher)Matchers.instanceOf(DefaultObjectType.class));
        Assert.assertThat((Object)paramModel.isRequired(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((TypeIdAnnotation)paramModel.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)Matchers.is((Object)Scheduler.class.getName()));
    }
}

