/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.component;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.component.Delegator;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ComponentInvocationHandlerTestCase
extends AbstractMuleTestCase {
    @Test
    public void notAnnotated() throws Exception {
        Component annotated = (Component)AnnotatedObjectInvocationHandler.addAnnotationsToClass(NotAnnotated.class).newInstance();
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.empty());
        annotated.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, "value"));
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.contains((Object[])new QName[]{AbstractComponent.LOCATION_KEY}));
        Assert.assertThat((Object)annotated.getClass().getMethod("setSomething", Object.class).isAnnotationPresent(Inject.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)AnnotatedObjectInvocationHandler.removeDynamicAnnotations((Object)annotated), (Matcher)Matchers.instanceOf(NotAnnotated.class));
        Assert.assertThat((Object)AnnotatedObjectInvocationHandler.removeDynamicAnnotations((Object)annotated), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(Component.class)));
    }

    @Test
    public void extendsAbstractAnnotated() throws Exception {
        Component annotated = (Component)AnnotatedObjectInvocationHandler.addAnnotationsToClass(ExtendsAnnotated.class).newInstance();
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.empty());
        annotated.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, "value"));
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.contains((Object[])new QName[]{AbstractComponent.LOCATION_KEY}));
        Assert.assertThat((Object)annotated.getClass().getMethod("setSomething", Object.class).isAnnotationPresent(Inject.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overridesAbstractAnnotated() throws Exception {
        Class clazz = AnnotatedObjectInvocationHandler.addAnnotationsToClass(ExtendsAnnotated.class);
        Method method = clazz.getMethod("setSomething", Object.class);
        Assert.assertThat((Object)method.getAnnotation(Inject.class), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void implementsAnnotated() throws Exception {
        Component annotated = (Component)AnnotatedObjectInvocationHandler.addAnnotationsToClass(ImplementsAnnotated.class).newInstance();
        Assert.assertThat((Object)annotated.getAnnotations(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void implementsInitialisable() throws Exception {
        Component annotated = (Component)AnnotatedObjectInvocationHandler.addAnnotationsToClass(ImplementsInitialisable.class).newInstance();
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.empty());
        annotated.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, "value"));
        Assert.assertThat(annotated.getAnnotations().keySet(), (Matcher)Matchers.contains((Object[])new QName[]{AbstractComponent.LOCATION_KEY}));
    }

    @Test
    public void differentClassLoader() throws Exception {
        ClassLoader childCl = this.createDelegatorClassLoader();
        Class annotatedClass = AnnotatedObjectInvocationHandler.addAnnotationsToClass(childCl.loadClass(Delegator.class.getName()));
        Assert.assertThat((Object)annotatedClass.getClassLoader(), (Matcher)Matchers.instanceOf(CompositeClassLoader.class));
    }

    private ClassLoader createDelegatorClassLoader() {
        ClassLoader testClassLoader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (Delegator.class.getName().equals(name)) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/org/mule/runtime/core/internal/component/Delegator.class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name);
            }
        };
        return testClassLoader;
    }

    public static class ImplementsInitialisable
    implements Initialisable {
        public void initialise() throws InitialisationException {
        }
    }

    public static class ImplementsAnnotated
    implements Component {
        public Object getAnnotation(QName name) {
            return null;
        }

        public Map<QName, Object> getAnnotations() {
            return null;
        }

        public void setAnnotations(Map<QName, Object> annotations) {
        }

        public ComponentLocation getLocation() {
            return null;
        }

        public Location getRootContainerLocation() {
            return null;
        }
    }

    public static class ExtendsAnnotated
    extends AbstractComponent {
        @Inject
        public void setSomething(Object something) {
        }
    }

    public static class NotAnnotated {
        private Object something;

        @Inject
        public void setSomething(Object something) {
            this.something = something;
        }

        public Object getSomething() {
            return this.something;
        }
    }
}

