/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.ClassUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.internal.config.bootstrap.FakeTransactionFactory;
import org.mule.runtime.core.internal.config.bootstrap.FakeTransactionResource;
import org.mule.runtime.core.internal.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.runtime.core.internal.config.bootstrap.TestBootstrapServiceDiscoverer;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SimpleRegistryBootstrapTestCase
extends AbstractMuleContextTestCase {
    public static final String TEST_TRANSACTION_FACTORY_CLASS = "org.foo.Connection";

    @Test(expected=ClassNotFoundException.class)
    public void registeringOptionalTransaction() throws Exception {
        this.createTestRegistryBootstrap(ArtifactType.APP);
        muleContext.getTransactionFactoryManager().getTransactionFactoryFor(ClassUtils.getClass((String)TEST_TRANSACTION_FACTORY_CLASS));
    }

    @Test
    public void existingNotOptionalTransaction() throws Exception {
        this.createTestRegistryBootstrap(ArtifactType.APP);
        TransactionFactory transactionFactoryFor = muleContext.getTransactionFactoryManager().getTransactionFactoryFor(FakeTransactionResource.class);
        Assert.assertNotNull((Object)transactionFactoryFor);
    }

    @Test
    public void registerOnlyAppPropertiesType() throws Exception {
        this.createTestRegistryBootstrap(ArtifactType.APP);
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(String.class), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(Properties.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(HashMap.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(ArrayList.class), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void registerOnlyDomainPropertiesType() throws Exception {
        this.createTestRegistryBootstrap(ArtifactType.DOMAIN);
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(String.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(Properties.class), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(HashMap.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(ArrayList.class), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void registerOnlyPolicyPropertiesType() throws Exception {
        this.createTestRegistryBootstrap(ArtifactType.POLICY);
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(String.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(Properties.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(HashMap.class), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(ArrayList.class), (Matcher)IsNull.notNullValue());
    }

    private SimpleRegistryBootstrap createTestRegistryBootstrap(ArtifactType artifactType) throws InitialisationException {
        Properties properties = new Properties();
        properties.put("1", String.format("java.lang.String,%s=%s", "applyToArtifactType", ArtifactType.APP.getAsString()));
        properties.put("2", String.format("java.util.Properties,%s=%s", "applyToArtifactType", ArtifactType.DOMAIN.getAsString()));
        properties.put("3", String.format("java.util.HashMap,%s=%s", "applyToArtifactType", ArtifactType.POLICY.getAsString()));
        properties.put("4", String.format("java.util.ArrayList,%s=%s/%s/%s", "applyToArtifactType", ArtifactType.APP.getAsString(), ArtifactType.DOMAIN.getAsString(), ArtifactType.POLICY.getAsString()));
        properties.put("jms.singletx.transaction.resource1", String.format("%s,optional)", TEST_TRANSACTION_FACTORY_CLASS));
        properties.put("test.singletx.transaction.factory1", FakeTransactionFactory.class.getName());
        properties.put("test.singletx.transaction.resource1", FakeTransactionResource.class.getName());
        TestBootstrapServiceDiscoverer bootstrapServiceDiscoverer = new TestBootstrapServiceDiscoverer(properties);
        ((DefaultMuleContext)muleContext).setBootstrapServiceDiscoverer((BootstrapServiceDiscoverer)bootstrapServiceDiscoverer);
        SimpleRegistryBootstrap simpleRegistryBootstrap = new SimpleRegistryBootstrap(artifactType, muleContext);
        simpleRegistryBootstrap.initialise();
        return simpleRegistryBootstrap;
    }
}

