/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.preferred;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.config.preferred.Preferred;
import org.mule.runtime.core.internal.config.preferred.PreferredObjectSelector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PreferredObjectSelectorTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSelectNoRegularClassIfThereIsNoPreferred() {
        ArrayList<NonPreferred> classes = new ArrayList<NonPreferred>();
        classes.add(new NonPreferred());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof NonPreferred));
    }

    @Test
    public void testSelectDefaultPreferredClassOverNoPreferredOne() {
        ArrayList<Object> classes = new ArrayList<Object>();
        classes.add(new NonPreferred());
        classes.add(new PreferredWithDefaultWeight());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof PreferredWithDefaultWeight));
    }

    @Test
    public void testSelectPreferredClassWithHighestWeight() {
        ArrayList<Object> classes = new ArrayList<Object>();
        classes.add(new NonPreferred());
        classes.add(new PreferredWithDefaultWeight());
        classes.add(new PreferredWithHighestWeight());
        PreferredObjectSelector selector = new PreferredObjectSelector();
        Object object = selector.select(classes.iterator());
        Assert.assertNotNull((String)"Selector selected a wrong object", (Object)(object instanceof PreferredWithHighestWeight));
    }

    @Preferred(weight=10)
    public class PreferredWithHighestWeight {
    }

    @Preferred
    public class PreferredWithDefaultWeight {
    }

    public class NonPreferred {
    }
}

