/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.CachedConnectionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Banana;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CachedConnectionHandlerTestCase
extends AbstractMuleTestCase {
    private Banana connection = new Banana();
    @Mock
    private ConnectionProvider<Banana> connectionProvider;
    @Mock
    private MuleContext muleContext;
    private CachedConnectionHandler<Banana> managedConnection;

    @Before
    public void before() throws Exception {
        this.stubConnectionProvider();
        this.managedConnection = new CachedConnectionHandler(this.connectionProvider, this.muleContext);
    }

    private void stubConnectionProvider() throws ConnectionException {
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connectionProvider.validate((Object)this.connection)).thenReturn((Object)ConnectionValidationResult.success());
    }

    @Test
    public void getConnection() throws Exception {
        Banana connection = (Banana)this.managedConnection.getConnection();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)connection)));
    }

    @Test
    public void returnsAlwaysSameConnectionAndConnectOnlyOnce() throws Exception {
        Banana connection1 = (Banana)this.managedConnection.getConnection();
        Banana connection2 = (Banana)this.managedConnection.getConnection();
        Assert.assertThat((Object)connection1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)connection2)));
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
    }

    @Test
    public void getConnectionConcurrentlyAndConnectOnlyOnce() throws Exception {
        Banana mockConnection = (Banana)Mockito.mock(Banana.class);
        this.connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        this.before();
        Latch latch = new Latch();
        Mockito.when((Object)this.connectionProvider.connect()).thenAnswer(invocation -> {
            new Thread(() -> {
                try {
                    latch.release();
                    this.getConnection();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).start();
            return mockConnection;
        });
        Banana connection = (Banana)this.managedConnection.getConnection();
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)mockConnection)));
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
    }

    @Test
    public void release() throws Exception {
        this.getConnection();
        this.managedConnection.release();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.never())).disconnect((Object)this.connection);
    }

    @Test
    public void close() throws Exception {
        this.getConnection();
        this.managedConnection.close();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect((Object)this.connection);
    }

    @Test
    public void invalidate() throws Exception {
        this.getConnection();
        this.managedConnection.invalidate();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect((Object)this.connection);
        Mockito.reset((Object[])new ConnectionProvider[]{this.connectionProvider});
        this.stubConnectionProvider();
        this.getConnection();
    }

    @Test
    public void getConnectionProvider() {
        Assert.assertThat((Object)this.managedConnection.getConnectionProvider(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.connectionProvider)));
    }
}

