/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.CachedConnectionManagementStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Banana;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CachedConnectionManagementStrategyTestCase
extends AbstractMuleTestCase {
    private Banana connection = new Banana();
    @Mock
    private ConnectionProvider<Banana> connectionProvider;
    @Mock
    private MuleContext muleContext;
    private CachedConnectionManagementStrategy<Banana> connectionStrategy;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)this.connection);
        this.connectionStrategy = new CachedConnectionManagementStrategy(this.connectionProvider, this.muleContext);
        Mockito.when((Object)this.connectionProvider.validate((Object)this.connection)).thenReturn((Object)ConnectionValidationResult.success());
    }

    @Test
    public void getConnection() throws Exception {
        ConnectionHandler connectionHandler = this.connectionStrategy.getConnectionHandler();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.never())).connect();
        Banana connection = (Banana)connectionHandler.getConnection();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }

    @Test
    public void close() throws Exception {
        this.connectionStrategy.getConnectionHandler().getConnection();
        this.connectionStrategy.close();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect((Object)this.connection);
    }
}

