/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.DefaultConnectionProviderWrapper;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultConnectionProviderWrapperTestCase
extends AbstractMuleContextTestCase {
    private static final String ERROR_MESSAGE = "BOOM ><";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Mock
    private ConnectionProvider<Object> connectionProvider;
    @Mock
    private Object connection;
    private DefaultConnectionProviderWrapper<Object> wrapper;
    @Mock
    private Injector injector;

    @Before
    public void before() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        Mockito.when((Object)muleContext.getInjector()).thenReturn((Object)this.injector);
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn(this.connection);
        this.wrapper = new DefaultConnectionProviderWrapper(this.connectionProvider, muleContext);
    }

    @Test
    public void connect() throws Exception {
        this.wrapper.connect();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
        ((Injector)Mockito.verify((Object)this.injector)).inject(this.connection);
    }

    @Test
    public void disconnect() throws Exception {
        this.wrapper.disconnect(this.connection);
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect(this.connection);
    }

    @Test
    public void alwaysThrowConnectionException() throws ConnectionException {
        this.exception.expect(ConnectionException.class);
        this.exception.expectCause(IsInstanceOf.instanceOf(NullPointerException.class));
        this.exception.expectMessage(ERROR_MESSAGE);
        this.wrapper = new DefaultConnectionProviderWrapper((ConnectionProvider)new TestProvider(), muleContext);
        this.wrapper.connect();
    }

    private class TestProvider
    implements ConnectionProvider {
        private TestProvider() {
        }

        public Object connect() throws ConnectionException {
            throw new NullPointerException(DefaultConnectionProviderWrapperTestCase.ERROR_MESSAGE);
        }

        public void disconnect(Object connection) {
        }

        public ConnectionValidationResult validate(Object connection) {
            return ConnectionValidationResult.success();
        }
    }
}

